/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.brew;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.brew.BaseBrewItem;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.xplat.XplatAbstractions;

public class InfiniteWineItem
extends BaseBrewItem {
    public static final int UPDATE_MODULO = 4000;
    private static final int MANA_PER_REGEN = 12000;
    public static final int AMPLIFIER_ADDITION = 1;
    public static final float DURATION_MULTIPLIER = 0.5f;

    public InfiniteWineItem(class_1792.class_1793 builder, int swigs, int drinkSpeed, Supplier<class_1792> baseItem) {
        super(builder, swigs, drinkSpeed, baseItem);
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (relic == null || !relic.isRightPlayer(player) || this.getSwigsLeft(stack) < 1) {
            return class_1271.method_22430((Object)stack);
        }
        return super.method_7836(world, player, hand);
    }

    @NotNull
    public class_1799 method_7861(@NotNull class_1799 stack, class_1937 world, class_1309 living) {
        if (!world.field_9236) {
            for (class_1293 effect : this.getBrew(stack).getPotionEffects(stack)) {
                class_1293 newEffect = new class_1293(effect.method_5579(), (int)((double)effect.method_5584() * (1.0 + (double)this.getDurationMultiplier())), effect.method_5578() + this.getAmplifierAddition(), true, true);
                if (effect.method_5579().method_5561()) {
                    effect.method_5579().method_5564((class_1297)living, (class_1297)living, living, newEffect.method_5578() + this.getAmplifierAddition(), 1.0);
                    continue;
                }
                living.method_6092(newEffect);
            }
            if (world.field_9229.method_43056()) {
                world.method_43128(null, living.method_23317(), living.method_23318(), living.method_23321(), class_3417.field_19149, class_3419.field_15248, 1.0f, 1.0f);
            }
            int swigs = this.getSwigsLeft(stack);
            if (living instanceof class_1657) {
                class_1657 player = (class_1657)living;
                if (!player.method_31549().field_7477) {
                    this.setSwigsLeft(stack, swigs - 1);
                }
            }
        }
        return stack;
    }

    public static Relic makeRelic(class_1799 stack) {
        return new RelicImpl(stack, null);
    }

    public void method_7851(@NotNull class_1799 stack, class_1937 world, @NotNull List<class_2561> tooltip, @NotNull class_1836 flags) {
        RelicImpl.addDefaultTooltip((class_1799)stack, tooltip);
        InfiniteWineItem.addPotionTooltip(this.getBrew(stack).getPotionEffects(stack), tooltip, (float)(1.0 + (double)this.getDurationMultiplier()), this.getAmplifierAddition());
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.field_9236 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null) {
                relic.tickBinding(player);
            }
            if (world.method_8510() % (long)this.getUpdateModulo() == 0L && this.getSwigsLeft(stack) < this.getSwigs() && ManaItemHandler.instance().requestManaExactForTool(stack, player, this.getManaPerRegen(), true)) {
                this.setSwigsLeft(stack, this.getSwigsLeft(stack) + 1);
            }
        }
    }

    public int getUpdateModulo() {
        return 4000;
    }

    public int getManaPerRegen() {
        return 12000;
    }

    public int getAmplifierAddition() {
        return 1;
    }

    public float getDurationMultiplier() {
        return 0.5f;
    }

    public static void addPotionTooltip(List<class_1293> list, List<class_2561> lores, float durationFactor, int amplifierAddition) {
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            lores.add((class_2561)class_2561.method_43471((String)"effect.none").method_27692(class_124.field_1080));
        } else {
            for (class_1293 effectinstance : list) {
                class_5250 iformattabletextcomponent = class_2561.method_43471((String)effectinstance.method_5586());
                class_1291 effect = effectinstance.method_5579();
                Map map = effect.method_5565();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        class_1322 attributemodifier = (class_1322)entry.getValue();
                        class_1322 attributemodifier1 = new class_1322(attributemodifier.method_6185(), effect.method_5563(effectinstance.method_5578() + amplifierAddition, attributemodifier), attributemodifier.method_6182());
                        list1.add(new Pair((Object)((class_1320)entry.getKey()), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.method_5578() + amplifierAddition > 0) {
                    iformattabletextcomponent = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{iformattabletextcomponent, class_2561.method_43471((String)("potion.potency." + (effectinstance.method_5578() + amplifierAddition)))});
                }
                if (effectinstance.method_5584() > 20) {
                    iformattabletextcomponent = class_2561.method_43469((String)"potion.withDuration", (Object[])new Object[]{iformattabletextcomponent, class_1292.method_5577((class_1293)effectinstance, (float)durationFactor)});
                }
                lores.add((class_2561)iformattabletextcomponent.method_27692(effect.method_18792().method_18793()));
            }
        }
        if (!list1.isEmpty()) {
            lores.add((class_2561)class_2561.method_43473());
            lores.add((class_2561)class_2561.method_43471((String)"potion.whenDrank").method_27692(class_124.field_1064));
            for (Pair pair : list1) {
                class_1322 attributemodifier2 = (class_1322)pair.getSecond();
                double d0 = attributemodifier2.method_6186();
                double d1 = attributemodifier2.method_6182() != class_1322.class_1323.field_6330 && attributemodifier2.method_6182() != class_1322.class_1323.field_6331 ? attributemodifier2.method_6186() : attributemodifier2.method_6186() * 100.0;
                if (d0 > 0.0) {
                    lores.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + attributemodifier2.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(d1), class_2561.method_43471((String)((class_1320)pair.getFirst()).method_26830())}).method_27692(class_124.field_1078));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + attributemodifier2.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(d1 *= -1.0), class_2561.method_43471((String)((class_1320)pair.getFirst()).method_26830())}).method_27692(class_124.field_1061));
            }
        }
    }
}

