/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.armor.pleiades_combat_maid;

import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.github.lounode.eventwrapper.event.entity.living.LivingDamageEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.LivingDeathEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.MobEffectEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.equipment.armor.pleiades_combat_maid.PleiadesCombatMaidSuitItem;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.brew.BotaniaMobEffects;
import vazkii.botania.common.brew.effect.BloodthirstMobEffect;

public class SanguinePleiadesCombatMaidSuitItem
extends PleiadesCombatMaidSuitItem {
    public static final Supplier<class_1799[]> ARMOR_SET = Suppliers.memoize(() -> new class_1799[]{new class_1799((class_1935)ExtraBotanyItems.pleiadesCombatMaidHeadgear), new class_1799((class_1935)ExtraBotanyItems.sanguinePleiadesCombatMaidSuit), new class_1799((class_1935)ExtraBotanyItems.pleiadesCombatMaidSkirt), new class_1799((class_1935)ExtraBotanyItems.pleiadesCombatMaidBoots)});
    public static int SANGUINE_KILL_REQUIRE = 50;
    public static final float HEAL_RATE = 0.3f;

    public SanguinePleiadesCombatMaidSuitItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        HashMultimap ret = super.method_7844(slot);
        if (slot == this.method_48398().method_48399()) {
            UUID uuid = new UUID(class_7923.field_41178.method_10221((Object)this).hashCode() + slot.toString().hashCode(), 0L);
            ret = HashMultimap.create(ret);
            ret.removeAll((Object)class_5134.field_23716);
            ret.put((Object)class_5134.field_23716, (Object)new class_1322(uuid, "Combatmaid modifier" + String.valueOf(this.field_41933), 15.0, class_1322.class_1323.field_6328));
        }
        return ret;
    }

    @Override
    public class_1799[] getArmorSetStacks() {
        return ARMOR_SET.get();
    }

    public static boolean isSenketsu(class_1799 stack) {
        String name = stack.method_7964().getString().toLowerCase(Locale.ROOT).trim();
        return "senketsu".equals(name);
    }

    @EventBusSubscriberWrapper
    public static class EventHandler {
        private static final Map<UUID, Integer> bloodthirstKilled = new ConcurrentHashMap<UUID, Integer>();

        @SubscribeEventWrapper
        public static void onAttackLiving(LivingDamageEventWrapper event) {
            class_1297 attacker = event.getSource().method_5529();
            if (!(attacker instanceof class_1309)) {
                return;
            }
            class_1309 living = (class_1309)attacker;
            if (!living.method_6118(class_1304.field_6174).method_31574(ExtraBotanyItems.sanguinePleiadesCombatMaidSuit)) {
                return;
            }
            living.method_6092(new class_1293(class_1294.field_5910, 200, 1));
            living.method_6025(0.3f * event.getAmount());
        }

        @SubscribeEventWrapper
        public static void onEffectAdded(MobEffectEventWrapper.Added event) {
            if (!(event.getEffectInstance().method_5579() instanceof BloodthirstMobEffect)) {
                return;
            }
            class_1309 class_13092 = event.getEntity();
            if (!(class_13092 instanceof class_3222)) {
                return;
            }
            class_3222 serverPlayer = (class_3222)class_13092;
            bloodthirstKilled.put(serverPlayer.method_5667(), 0);
        }

        @SubscribeEventWrapper
        public static void onKilled(LivingDeathEventWrapper event) {
            class_1297 class_12972 = event.getSource().method_5529();
            if (!(class_12972 instanceof class_3222)) {
                return;
            }
            class_3222 serverPlayer = (class_3222)class_12972;
            if (!serverPlayer.method_6059(BotaniaMobEffects.bloodthrst)) {
                return;
            }
            bloodthirstKilled.computeIfPresent(serverPlayer.method_5667(), (uuid, count) -> count + 1);
        }

        @SubscribeEventWrapper
        public static void onEffectRemove(MobEffectEventWrapper.Remove event) {
            class_1309 class_13092 = event.getEntity();
            if (class_13092 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_13092;
                EventHandler.onEffectRemovedOrExpired(serverPlayer, event.getEffectInstance());
            }
        }

        @SubscribeEventWrapper
        public static void onEffectExpired(MobEffectEventWrapper.Expired event) {
            class_1309 class_13092 = event.getEntity();
            if (class_13092 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_13092;
                EventHandler.onEffectRemovedOrExpired(serverPlayer, event.getEffectInstance());
            }
        }

        private static void onEffectRemovedOrExpired(class_3222 serverPlayer, @Nullable class_1293 instance) {
            if (instance == null) {
                return;
            }
            if (!(instance.method_5579() instanceof BloodthirstMobEffect)) {
                return;
            }
            if (!bloodthirstKilled.containsKey(serverPlayer.method_5667())) {
                return;
            }
            EventHandler.replaceArmor(serverPlayer);
        }

        private static void replaceArmor(class_3222 serverPlayer) {
            int killed = bloodthirstKilled.get(serverPlayer.method_5667());
            bloodthirstKilled.remove(serverPlayer.method_5667());
            class_1799 origin = serverPlayer.method_6118(class_1304.field_6174);
            if (killed >= SANGUINE_KILL_REQUIRE && origin.method_31574(ExtraBotanyItems.pleiadesCombatMaidSuit)) {
                class_1799 darkened = new class_1799((class_1935)ExtraBotanyItems.sanguinePleiadesCombatMaidSuit);
                class_2487 originTag = origin.method_7969();
                if (originTag != null) {
                    class_2487 newTag = originTag.method_10553();
                    darkened.method_7980(newTag);
                }
                serverPlayer.method_5673(class_1304.field_6174, darkened);
            }
        }
    }
}

