/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.bauble;

import io.github.lounode.eventwrapper.event.entity.player.PlayerInteractEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.api.item.NatureEnergyItem;
import io.github.lounode.extrabotany.common.entity.gaia.GaiaIII;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_4081;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;

@EventBusSubscriberWrapper
public class NatureOrbItem
extends BaubleItem
implements CustomCreativeTabContents {
    public static final long MAX_ENERGY = 500000L;
    public static final int SPAWN_GAIAIII_COST = 200000;
    public static final int TIER_1_ENERGY = 100000;
    public static final int TIER_2_ENERGY = 200000;
    public static final int TIER_3_ENERGY = 300000;
    public static final int TIER_4_ENERGY = 400000;
    public static final int MANA_GENERATE_ADDITION_PER_TIER = 1;
    public static final int HEAL_DELAY = 60;
    public static final float HEAL_AMOUNT = 1.0f;
    public static final int REMOVE_HARMFUL_POTION_DELAY = 40;
    public static final int REMOVE_HARMFUL_POTION_COST = 200;
    private static final String TAG_ENERGY = "NatureEnergy";

    public NatureOrbItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public void addToCreativeTab(class_1792 me, class_1761.class_7704 output) {
        output.method_45421((class_1935)this);
        class_1799 fullPower = new class_1799((class_1935)this);
        NatureOrbItem.setEnergy(fullPower, 500000L);
        output.method_45420(fullPower);
    }

    public class_1269 method_7884(class_1838 context) {
        class_2338 pos = context.method_8037();
        class_1937 level = context.method_8045();
        class_2586 tile = level.method_8321(pos);
        if (tile instanceof class_2580) {
            return class_1269.field_21466;
        }
        return super.method_7884(context);
    }

    @SubscribeEventWrapper
    public static void onPlayerInteract(PlayerInteractEventWrapper.RightClickBlock event) {
        class_1792 class_17922;
        class_1657 player = event.getEntity();
        class_2338 pos = event.getPos();
        class_1799 handItem = event.getItemStack();
        class_1799 equipItem = EquipmentHandler.findOrEmpty((class_1792)ExtraBotanyItems.natureOrb, (class_1309)player);
        class_1268 hand = event.getHand();
        class_1937 level = player.method_37908();
        class_2586 tile = level.method_8321(pos);
        if (!player.method_5715()) {
            return;
        }
        class_1799 finalItem = handItem;
        if (handItem.method_7960() && hand == class_1268.field_5810) {
            finalItem = equipItem;
        }
        if (tile instanceof class_2580 && (class_17922 = finalItem.method_7909()) instanceof NatureOrbItem) {
            NatureOrbItem orb = (NatureOrbItem)class_17922;
            NatureEnergyItem natureItem = EXplatAbstractions.INSTANCE.findNatureEnergyItem(finalItem);
            if (natureItem == null || natureItem.getEnergy() < (long)orb.getSpawnGaiaCost()) {
                return;
            }
            if (GaiaIII.spawn(player, finalItem, level, pos)) {
                if (!level.method_8608()) {
                    natureItem.addEnergy(-orb.getSpawnGaiaCost());
                    event.setCanceled(true);
                }
                player.method_6104(hand);
            }
        }
    }

    public void onWornTick(class_1799 stack, class_1309 entity) {
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        NatureEnergyItem natureItem = EXplatAbstractions.INSTANCE.findNatureEnergyItem(stack);
        if (natureItem == null) {
            return;
        }
        if (NatureOrbItem.getTier(stack) >= 1) {
            ManaItemHandler.instance().dispatchManaExact(stack, player, 1, true);
        }
        if (NatureOrbItem.getTier(stack) >= 2) {
            ManaItemHandler.instance().dispatchManaExact(stack, player, 1, true);
        }
        if (NatureOrbItem.getTier(stack) >= 3) {
            ManaItemHandler.instance().dispatchManaExact(stack, player, 1, true);
            if (player.field_6012 % 60 == 0) {
                player.method_6025(1.0f);
            }
        }
        if (NatureOrbItem.getTier(stack) >= 4) {
            if (player.field_6012 % 40 != 0) {
                return;
            }
            int removeCount = NatureOrbItem.clearHarmfulPotion((class_1309)player);
            if (removeCount > 0) {
                natureItem.addEnergy(-200L * (long)removeCount);
            }
        }
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
        super.method_7851(stack, world, tooltip, flags);
        NatureEnergyItem natureItem = EXplatAbstractions.INSTANCE.findNatureEnergyItem(stack);
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.extrabotany.nature_orb.tier1").method_27692(NatureOrbItem.getTier(stack) >= 1 ? class_124.field_1075 : class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.extrabotany.nature_orb.tier2").method_27692(NatureOrbItem.getTier(stack) >= 3 ? class_124.field_1061 : class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.extrabotany.nature_orb.tier3").method_27692(NatureOrbItem.getTier(stack) >= 4 ? class_124.field_1060 : class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43473());
        tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.extrabotany.nature_orb.energy", (Object[])new Object[]{natureItem.getEnergy() + "/" + natureItem.getMaxEnergy()}).method_27692(class_124.field_1080));
    }

    public static int getTier(class_1799 stack) {
        NatureEnergyItem natureItem = EXplatAbstractions.INSTANCE.findNatureEnergyItem(stack);
        if (natureItem == null) {
            return -1;
        }
        long energy = natureItem.getEnergy();
        if (energy > 400000L) {
            return 4;
        }
        if (energy > 300000L) {
            return 3;
        }
        if (energy > 200000L) {
            return 2;
        }
        if (energy > 100000L) {
            return 1;
        }
        return 0;
    }

    public static int clearHarmfulPotion(class_1309 entity) {
        List<class_1293> effects = entity.method_6026().stream().filter(effect -> effect.method_5579().method_18792() == class_4081.field_18272).toList();
        effects.forEach(e -> entity.method_6016(e.method_5579()));
        return effects.size();
    }

    public int getSpawnGaiaCost() {
        return 200000;
    }

    protected static void setEnergy(class_1799 stack, long energy) {
        if (energy > 0L) {
            ItemNBTHelper.setLong((class_1799)stack, (String)TAG_ENERGY, (long)energy);
        } else {
            ItemNBTHelper.removeEntry((class_1799)stack, (String)TAG_ENERGY);
        }
    }

    public int method_31571(class_1799 stack) {
        NatureEnergyItem natureItem = EXplatAbstractions.INSTANCE.findNatureEnergyItem(stack);
        return class_3532.method_15369((float)((float)natureItem.getEnergy() / (float)natureItem.getMaxEnergy() / 3.0f), (float)1.0f, (float)1.0f);
    }

    public int method_31569(class_1799 stack) {
        NatureEnergyItem natureItem = EXplatAbstractions.INSTANCE.findNatureEnergyItem(stack);
        return Math.round(13.0f * ((float)natureItem.getEnergy() / (float)natureItem.getMaxEnergy()));
    }

    public boolean method_31567(class_1799 stack) {
        NatureEnergyItem natureItem = EXplatAbstractions.INSTANCE.findNatureEnergyItem(stack);
        return natureItem.getEnergy() < natureItem.getMaxEnergy();
    }

    public static class NatureEnergyImpl
    implements NatureEnergyItem {
        private final class_1799 stack;

        public NatureEnergyImpl(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        public long getEnergy() {
            return ItemNBTHelper.getLong((class_1799)this.stack, (String)NatureOrbItem.TAG_ENERGY, (long)0L) * (long)this.stack.method_7947();
        }

        @Override
        public long getMaxEnergy() {
            return 500000L * (long)this.stack.method_7947();
        }

        @Override
        public boolean addEnergy(long energy) {
            long current = this.getEnergy() / (long)this.stack.method_7947();
            long maxSingle = this.getMaxEnergy() / (long)this.stack.method_7947();
            long newEnergy = energy > 0L && current > maxSingle - energy ? maxSingle : (energy < 0L && current < -energy ? 0L : current + energy);
            newEnergy = Math.min(newEnergy, maxSingle);
            newEnergy = Math.max(newEnergy, 0L);
            NatureOrbItem.setEnergy(this.stack, newEnergy);
            return newEnergy != current;
        }
    }
}

