/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.tool.hammer;

import io.github.lounode.eventwrapper.event.entity.player.PlayerEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.api.item.IAerialite;
import io.github.lounode.extrabotany.api.item.IOrichalcos;
import io.github.lounode.extrabotany.api.item.IPhotonium;
import io.github.lounode.extrabotany.api.item.IShadowium;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.equipment.tool.hammer.TerrasteelHammerItem;
import io.github.lounode.extrabotany.common.item.material.HammerTiers;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.Relic;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.xplat.XplatAbstractions;

@EventBusSubscriberWrapper
public class RheinHammerItem
extends TerrasteelHammerItem
implements IShadowium,
IPhotonium,
IAerialite,
IOrichalcos {
    private static final int MANA_PER_DAMAGE = 300;
    private static final int ACTIVE_COST = 30;
    public static final int RANGE = 5;
    public static final int BUFF_MANA = 200;
    private static final String ADVANCEMENT_NAME = "spongebob";

    public RheinHammerItem(class_1792.class_1793 props) {
        this(HammerTiers.RHEIN, 4, -3.0f, props);
    }

    public RheinHammerItem(class_1832 tier, int attackDamageModifier, float attackSpeedModifier, class_1792.class_1793 properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        super.method_7851(stack, level, tooltipComponents, isAdvanced);
        RelicImpl.addDefaultTooltip((class_1799)stack, tooltipComponents);
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_3222 serverPlayer;
        super.method_7888(stack, world, entity, slot, selected);
        if (!world.field_9236 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null) {
                relic.tickBinding(player);
            }
        }
        if (entity instanceof class_3222 && this.checkAdvancement(stack, serverPlayer = (class_3222)entity)) {
            PlayerHelper.grantCriterion((class_3222)serverPlayer, (class_2960)ResourceLocationHelper.prefix("main/sponge_hammer"), (String)"code_triggered");
        }
        if (!RheinHammerItem.isEnabled(stack)) {
            return;
        }
        this.shadowiumTick(stack, world, entity, slot, selected);
        this.photoniumTick(stack, world, entity, slot, selected);
        this.aerialiteTick(stack, world, entity, slot, selected);
        this.orichalcosTick(stack, world, entity, slot, selected);
    }

    private boolean checkAdvancement(class_1799 stack, class_3222 serverPlayer) {
        if (PlayerHelper.hasAdvancement((class_3222)serverPlayer, (class_2960)ResourceLocationHelper.prefix("main/sponge_hammer"))) {
            return false;
        }
        return ADVANCEMENT_NAME.equals(stack.method_7964().getString().toLowerCase(Locale.ROOT));
    }

    public boolean method_24357(class_1282 damageSource) {
        return IOrichalcos.canBeHurtBy(damageSource);
    }

    @SubscribeEventWrapper
    public static void onDig(PlayerEventWrapper.BreakSpeed wrapper) {
        class_1799 _left = wrapper.getEntity().method_5998(class_1268.field_5810);
        class_1799 _right = wrapper.getEntity().method_5998(class_1268.field_5808);
        class_1799 stack = class_1799.field_8037;
        if (_left.method_31574(ExtraBotanyItems.rheinHammer)) {
            stack = _left;
        } else if (_right.method_31574(ExtraBotanyItems.rheinHammer)) {
            stack = _right;
        }
        if (stack.method_7960() || !stack.method_31574(ExtraBotanyItems.rheinHammer)) {
            return;
        }
        if (stack.method_31574(ExtraBotanyItems.rheinHammer) && !RheinHammerItem.isEnabled(stack)) {
            wrapper.setNewSpeed(0.0f);
            wrapper.setCanceled(true);
        }
    }

    @Override
    public int getManaPerDamage() {
        return 300;
    }

    @Override
    public int getActiveCost() {
        return 30;
    }

    @Override
    public int getRange(class_1657 player, class_1799 stack, class_2338 pos, class_2338 originPos, class_2350 side) {
        return 5;
    }

    @Override
    public int getShadowiumBuffMana() {
        return 200;
    }

    @Override
    public int getPhotoniumBuffMana() {
        return 200;
    }

    @Override
    public int getAerialiteBuffMana() {
        return 200;
    }

    @Override
    public int getOrichalcosBuffMana() {
        return 200;
    }

    @Override
    public boolean isNight(class_1937 level) {
        return true;
    }

    @Override
    public boolean isInCave(class_1937 level, class_2338 pos) {
        return true;
    }

    @Override
    public boolean isDay(class_1937 level) {
        return true;
    }

    @Override
    public boolean isOutCave(class_1937 level, class_2338 pos) {
        return true;
    }

    public static Relic makeRelic(class_1799 stack) {
        return new RelicImpl(stack, ResourceLocationHelper.prefix("main/rhein_kraft"));
    }
}

