/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.github.lounode.extrabotany.common.item.equipment.shield.ManasteelShieldItem;
import io.github.lounode.extrabotany.common.item.material.ItemTiers;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.handler.PixieHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.xplat.XplatAbstractions;

public class AchillesShieldItem
extends ManasteelShieldItem {
    public static final String TAG_RELEASED = "released";
    private static final float RELEASE_ABSORPTION_REQUIRE = 10.0f;
    private static final float MAX_ABSORPTION = 20.0f;

    public AchillesShieldItem(class_1792.class_1793 properties) {
        super(properties.method_7898(ItemTiers.ACHILLES_SHIELD.method_8025()), ItemTiers.ACHILLES_SHIELD);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!AchillesShieldItem.isReleased(stack)) {
            if (hand == class_1268.field_5808 && player.method_21823() && player.method_6067() >= 10.0f) {
                AchillesShieldItem.setReleased(stack, true);
                return class_1271.method_22427((Object)stack);
            }
            return super.method_7836(level, player, hand);
        }
        if (hand == class_1268.field_5808 && player.method_21823()) {
            AchillesShieldItem.setReleased(stack, false);
            return class_1271.method_22427((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (!world.field_9236 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null) {
                relic.tickBinding(player);
            }
            if (AchillesShieldItem.isReleased(stack) && player.field_6012 % 10 == 0) {
                if (player.method_6067() <= 0.0f) {
                    AchillesShieldItem.setReleased(stack, false);
                }
                player.method_6073(player.method_6067() - 1.0f);
            }
        }
    }

    public void method_7852(class_1937 level, class_1309 entity, class_1799 stack, int remainingUseDuration) {
        super.method_7852(level, entity, stack, remainingUseDuration);
        if (AchillesShieldItem.isReleased(stack)) {
            entity.method_6021();
        }
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (AchillesShieldItem.isReleased(stack)) {
            BotaniaItems.thunderSword.method_7873(stack, target, attacker);
        } else {
            attacker.method_6073(Math.min(20.0f, attacker.method_6067() + 2.0f));
        }
        return super.method_7873(stack, target, attacker);
    }

    @Override
    public void onShieldBlock(class_1799 stack, class_1309 blocker, class_1282 source, float damage) {
        class_1657 player;
        super.onShieldBlock(stack, blocker, source, damage);
        class_1297 attacker = source.method_5529();
        if (attacker == null) {
            return;
        }
        if (blocker instanceof class_1657 && ManaItemHandler.INSTANCE.requestManaExactForTool(stack, player = (class_1657)blocker, 500, true)) {
            attacker.method_5643(player.method_48923().method_48818((class_1297)player), damage);
        }
    }

    public static boolean isReleased(class_1799 stack) {
        return ItemNBTHelper.getBoolean((class_1799)stack, (String)TAG_RELEASED, (boolean)false);
    }

    public static void setReleased(class_1799 stack, boolean mode) {
        ItemNBTHelper.setBoolean((class_1799)stack, (String)TAG_RELEASED, (boolean)mode);
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1304 slot, class_1799 stack) {
        Multimap ret = super.method_7844(slot);
        ret = HashMultimap.create((Multimap)ret);
        if (slot == class_1304.field_6173) {
            UUID uuid = new UUID((this.method_7876() + String.valueOf(slot)).hashCode(), 0L);
            if (AchillesShieldItem.isReleased(stack)) {
                ret.put((Object)class_5134.field_23719, (Object)new class_1322(uuid, "Tool modifier", (double)0.4f, class_1322.class_1323.field_6330));
            }
            ret.put((Object)class_5134.field_23723, (Object)new class_1322(uuid, "Tool modifier", -2.6, class_1322.class_1323.field_6328));
            ret.put((Object)class_5134.field_23721, (Object)new class_1322(uuid, "Weapon modifier", AchillesShieldItem.isReleased(stack) ? 15.0 : 6.0, class_1322.class_1323.field_6328));
        }
        if (slot == class_1304.field_6171) {
            ret.put((Object)PixieHandler.PIXIE_SPAWN_CHANCE, (Object)PixieHandler.makeModifier((class_1304)slot, (String)"Shield modifier", (double)0.5));
        }
        return ret;
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        return this.getAttributeModifiers(slot, stack);
    }

    public static Relic makeRelic(class_1799 stack) {
        return new RelicImpl(stack, null);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 flags) {
        super.method_7851(stack, world, tooltip, flags);
        RelicImpl.addDefaultTooltip((class_1799)stack, tooltip);
    }
}

