/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lounode.eventwrapper.event.entity.player.ItemCooldownFinishEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.api.item.IShadowium;
import io.github.lounode.extrabotany.common.brew.ExtraBotanyMobEffects;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import io.github.lounode.extrabotany.common.util.SoundEventUtil;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5328;
import org.joml.Vector3f;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.common.item.relic.RelicItem;
import vazkii.botania.xplat.XplatAbstractions;

@EventBusSubscriberWrapper
public class CameraItem
extends RelicItem
implements IShadowium {
    private static final int MANA_PER_USE = 1500;
    private static final int RANGE = 20;
    private static final int ADVANCEMENT_REQUIRE = 10;

    public CameraItem(class_1792.class_1793 props) {
        super(props);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (relic == null || !relic.isRightPlayer(player) || !ManaItemHandler.instance().requestManaExactForTool(stack, player, 1500, false)) {
            return class_1271.method_22430((Object)stack);
        }
        player.method_17356(ExtraBotanySounds.CAMERA_FOCUS, class_3419.field_15248, 0.3f, SoundEventUtil.randomPitch(world));
        return class_5328.method_29282((class_1937)world, (class_1657)player, (class_1268)hand);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 entity, int timeLeft) {
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        if (CameraItem.executeCapture(world, player, player.method_6058()).method_5467() == class_1269.field_5812) {
            player.method_7357().method_7906((class_1792)this, 160);
        }
    }

    public int method_7881(class_1799 stack) {
        return 1200;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_27079;
    }

    public static class_1271<class_1799> executeCapture(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (relic != null && (player.method_7337() || relic.isRightPlayer(player) && ManaItemHandler.instance().requestManaExactForTool(stack, player, 1500, true))) {
            List<class_1309> livingEntities = world.method_18467(class_1309.class, CameraItem.getFreezeBounds(player)).stream().filter(entity -> !entity.equals((Object)player)).filter(entity -> entity.method_5781() == null || !entity.method_5781().method_1206(player.method_5781())).toList();
            for (class_1309 livingEntity : livingEntities) {
                livingEntity.method_6092(new class_1293(ExtraBotanyMobEffects.LINK, 200));
            }
            if (!world.method_8608() && livingEntities.size() >= 10) {
                PlayerHelper.grantCriterion((class_3222)((class_3222)player), (class_2960)ResourceLocationHelper.prefix("main/i_see_everything"), (String)"code_triggered");
            }
            List<class_1676> projectiles = world.method_18467(class_1676.class, CameraItem.getFreezeBounds(player)).stream().filter(entity -> entity.method_24921() != player).filter(entity -> entity.method_5781() == null || !entity.method_5781().method_1206(player.method_5781())).toList();
            for (class_1676 projectile : projectiles) {
                projectile.method_5650(class_1297.class_5529.field_26999);
            }
            world.method_45447(null, player.method_23312(), ExtraBotanySounds.CAMERA_USE, class_3419.field_15248);
            return class_1271.method_22427((Object)stack);
        }
        return class_1271.method_22430((Object)player.method_5998(hand));
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        this.shadowiumTick(stack, world, entity, slot, selected);
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        super.method_7888(stack, world, entity, slot, selected);
        class_1799 usingItem = player.method_6030();
        if (usingItem.method_7960() || !(usingItem.method_7909() instanceof CameraItem)) {
            return;
        }
        class_238 bounds = CameraItem.getFreezeBounds(player);
        List<class_1309> targets = player.method_37908().method_18467(class_1309.class, bounds).stream().filter(e -> !e.equals((Object)player)).filter(e -> e.method_5781() == null || !e.method_5781().method_1206(player.method_5781())).toList();
        for (class_1309 target : targets) {
            target.method_6092(new class_1293(class_1294.field_5912, 2, 0, false, true, true));
        }
    }

    public static void renderAABBBorder(class_1937 level, class_238 bounds) {
        int particleDensity = 10;
        float red = 1.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float scale = 1.0f;
        double xStep = (bounds.field_1320 - bounds.field_1323) / (double)particleDensity;
        double yStep = (bounds.field_1325 - bounds.field_1322) / (double)particleDensity;
        double zStep = (bounds.field_1324 - bounds.field_1321) / (double)particleDensity;
        for (int i = 0; i <= particleDensity; ++i) {
            CameraItem.spawnParticle(level, bounds.field_1323 + xStep * (double)i, bounds.field_1322, bounds.field_1321, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.field_1323 + xStep * (double)i, bounds.field_1322, bounds.field_1324, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.field_1323, bounds.field_1322, bounds.field_1321 + zStep * (double)i, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.field_1320, bounds.field_1322, bounds.field_1321 + zStep * (double)i, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.field_1323 + xStep * (double)i, bounds.field_1325, bounds.field_1321, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.field_1323 + xStep * (double)i, bounds.field_1325, bounds.field_1324, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.field_1323, bounds.field_1325, bounds.field_1321 + zStep * (double)i, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.field_1320, bounds.field_1325, bounds.field_1321 + zStep * (double)i, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.field_1323, bounds.field_1322 + yStep * (double)i, bounds.field_1321, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.field_1320, bounds.field_1322 + yStep * (double)i, bounds.field_1321, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.field_1323, bounds.field_1322 + yStep * (double)i, bounds.field_1324, red, green, blue, scale);
            CameraItem.spawnParticle(level, bounds.field_1320, bounds.field_1322 + yStep * (double)i, bounds.field_1324, red, green, blue, scale);
        }
    }

    private static void spawnParticle(class_1937 level, double x, double y, double z, float r, float g, float b, float scale) {
        if (level.field_9236) {
            level.method_8406((class_2394)new class_2390(new Vector3f(r, g, b), scale), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @SubscribeEventWrapper
    public static void onItemCooldownFinish(ItemCooldownFinishEventWrapper event) {
        if (!(event.getItem() instanceof CameraItem)) {
            return;
        }
        class_1657 player = event.getEntity();
        if (!player.method_37908().method_8608()) {
            return;
        }
        player.method_17356(ExtraBotanySounds.CAMERA_CHARGE, class_3419.field_15248, 0.3f, SoundEventUtil.randomPitch(player.method_37908()));
    }

    public int getManaPerUse() {
        return 1500;
    }

    public int getRange() {
        return 20;
    }

    public static class_238 getFreezeBounds(class_1657 player) {
        class_243 lookVec = player.method_5720();
        class_243 center = player.method_33571().method_1019(lookVec.method_1021(15.0));
        double halfRange = 10.0;
        return new class_238(center.field_1352 - halfRange, center.field_1351 - halfRange, center.field_1350 - halfRange, center.field_1352 + halfRange, center.field_1351 + halfRange, center.field_1350 + halfRange);
    }

    public static Relic makeRelic(class_1799 stack) {
        return new RelicImpl(stack, null);
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.extrabotany.camera").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        super.method_7851(stack, world, tooltip, flags);
    }

    public static class Hud {
        public static final class_2960 CAMERA_UI_LOCATION = ResourceLocationHelper.prefix("textures/gui/spyglass_scope.png");

        public static void renderSpyglassOverlay(class_332 pGuiGraphics, float pScopeScale) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float f = Math.min(pGuiGraphics.method_51421(), pGuiGraphics.method_51443());
            float f1 = Math.min((float)pGuiGraphics.method_51421() / f, (float)pGuiGraphics.method_51443() / f) * pScopeScale;
            int i = class_3532.method_15375((float)(f * f1));
            int j = class_3532.method_15375((float)(f * f1));
            int k = (pGuiGraphics.method_51421() - i) / 2;
            int l = (pGuiGraphics.method_51443() - j) / 2;
            int i1 = k + i;
            int j1 = l + j;
            pGuiGraphics.method_25291(CAMERA_UI_LOCATION, k, l, -90, 0.0f, 0.0f, i, j, i, j);
            RenderSystem.disableBlend();
        }
    }
}

