/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.github.lounode.eventwrapper.event.entity.player.AttackEntityEventWrapper;
import io.github.lounode.eventwrapper.event.entity.player.PlayerInteractEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.common.ExtraBotanyDamageTypes;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.material.ItemTiers;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import io.github.lounode.extrabotany.network.serverbound.LeftClickPacketExcalibur;
import io.github.lounode.extrabotany.xplat.ExClientXplatAbstractions;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.LensEffectItem;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelSwordItem;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.xplat.XplatAbstractions;

@EventBusSubscriberWrapper
public class ExcaliburItem
extends ManasteelSwordItem
implements LensEffectItem {
    private static final int MANA_PER_DAMAGE = 200;
    public static final double SEARCH_TARGET_RADIUS = 5.0;

    public ExcaliburItem(class_1792.class_1793 props) {
        super((class_1832)ItemTiers.EXCALIBUR, 8, -2.0f, props);
    }

    @SubscribeEventWrapper
    public static void leftClick(PlayerInteractEventWrapper.LeftClickEmpty event) {
        class_1799 stack = event.getItemStack();
        if (!stack.method_7960() && stack.method_7909() instanceof ExcaliburItem) {
            ExClientXplatAbstractions.INSTANCE.sendToServer(LeftClickPacketExcalibur.INSTANCE);
        }
    }

    @SubscribeEventWrapper
    public static void attackEntity(AttackEntityEventWrapper event) {
        class_1657 player = event.getEntity();
        if (!player.method_37908().field_9236 && player.method_6047().method_7909() instanceof ExcaliburItem) {
            ExcaliburItem.trySpawnBurst(player, player.method_7261(0.0f));
        }
    }

    public static void trySpawnBurst(class_1657 player, float attackStrength) {
        class_1799 stack = player.method_6047();
        if (!stack.method_31574(ExtraBotanyItems.excalibur)) {
            return;
        }
        Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
        if (relic == null || !relic.isRightPlayer(player)) {
            return;
        }
        ExcaliburItem.trySpawnBurstUnsafe(player, attackStrength);
    }

    public static void trySpawnBurstUnsafe(class_1657 player, float attackStrength) {
        if (player.method_7325() || attackStrength != 1.0f) {
            return;
        }
        ManaBurstEntity burst = ExcaliburItem.getBurst(player, player.method_6047());
        player.method_37908().method_8649((class_1297)burst);
        player.method_6047().method_7956(1, (class_1309)player, p -> p.method_20236(class_1268.field_5808));
        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), ExtraBotanySounds.EXCALIBUR_ATTACK, class_3419.field_15248, 1.0f, 1.0f);
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        Multimap ret = super.method_7844(slot);
        if (slot == class_1304.field_6173) {
            ret = HashMultimap.create((Multimap)ret);
            ret.put((Object)class_5134.field_23719, (Object)new class_1322(UUID.fromString("995829fa-94c0-41bd-b046-0468c509a488"), "Excaliber modifier", 0.3, class_1322.class_1323.field_6331));
        }
        return ret;
    }

    public static ManaBurstEntity getBurst(class_1657 player, class_1799 stack) {
        ManaBurstEntity burst = new ManaBurstEntity(player){

            public boolean method_31746() {
                return false;
            }
        };
        float motionModifier = 9.0f;
        burst.setColor(0xFFFF20);
        burst.setMana(200);
        burst.setStartingMana(200);
        burst.setMinManaLoss(40);
        burst.setManaLossPerTick(4.0f);
        burst.setGravity(0.0f);
        burst.method_18799(burst.method_18798().method_1021((double)motionModifier));
        burst.setSourceLens(stack.method_7972());
        return burst;
    }

    public void updateBurst(ManaBurst burst, class_1799 stack) {
        block8: {
            class_1657 player;
            class_1297 thrower;
            ManaBurstEntity burstEntity;
            block7: {
                block6: {
                    burstEntity = (ManaBurstEntity)burst.entity();
                    thrower = burstEntity.method_24921();
                    if (!(thrower instanceof class_1657)) break block6;
                    player = (class_1657)thrower;
                    if (thrower.method_5805()) break block7;
                }
                burstEntity.method_31472();
                return;
            }
            this.rotateToEnemy(burstEntity);
            if (burstEntity.method_37908().method_8608()) {
                return;
            }
            class_238 axis = new class_238(burstEntity.method_23317(), burstEntity.method_23318(), burstEntity.method_23321(), burstEntity.field_6038, burstEntity.field_5971, burstEntity.field_5989).method_1014(1.0);
            List<class_1309> entities = burstEntity.method_37908().method_18467(class_1309.class, axis).stream().filter(e -> e != thrower).filter(e -> {
                class_1657 other;
                return !(e instanceof class_1657 && !player.method_7256(other = (class_1657)e));
            }).filter(e -> e.field_6235 == 0).toList();
            Iterator<class_1309> iterator = entities.iterator();
            if (!iterator.hasNext()) break block8;
            class_1309 entity = iterator.next();
            int cost = 66;
            int mana = burst.getMana();
            if (mana >= cost) {
                burst.setMana(mana - cost);
                float damage = 5.0f + ItemTiers.EXCALIBUR.method_8028();
                class_1282 source = ExtraBotanyDamageTypes.Sources.excaliburDamage(player.method_37908().method_30349(), (class_1297)player);
                entity.method_5643(source, damage);
                burstEntity.method_31472();
            }
        }
    }

    private void rotateToEnemy(ManaBurstEntity burstEntity) {
        class_238 searchBox = new class_238(burstEntity.method_23317(), burstEntity.method_23318(), burstEntity.method_23321(), burstEntity.field_6038, burstEntity.field_5971, burstEntity.field_5989).method_1014(5.0);
        burstEntity.method_37908().method_18467(class_1309.class, searchBox).stream().filter(ExcaliburItem::canTargetEntity).filter(living -> living.field_6235 == 0).filter(living -> living != burstEntity.method_24921()).sorted(Comparator.comparingInt(ExcaliburItem::getEntityPriority)).findFirst().ifPresent(target -> {
            class_243 thisVec = VecHelper.fromEntityCenter((class_1297)burstEntity);
            class_243 targetVec = VecHelper.fromEntityCenter((class_1297)target);
            class_243 diffVec = targetVec.method_1020(thisVec);
            class_243 motionVec = diffVec.method_1029().method_1021(0.6);
            burstEntity.method_18799(motionVec);
        });
    }

    private static boolean canTargetEntity(class_1309 entity) {
        return entity instanceof class_1308 || entity instanceof class_1657;
    }

    private static int getEntityPriority(class_1309 entity) {
        if (entity instanceof class_1308) {
            return 3;
        }
        if (entity instanceof class_1657) {
            return 2;
        }
        if (entity instanceof class_1429) {
            return 1;
        }
        return 0;
    }

    public void apply(class_1799 stack, BurstProperties props, class_1937 level) {
    }

    public boolean collideBurst(ManaBurst burst, class_239 pos, boolean isManaBlock, boolean shouldKill, class_1799 stack) {
        return shouldKill;
    }

    public boolean doParticles(ManaBurst burst, class_1799 stack) {
        return true;
    }

    public int getManaPerDamage() {
        return 200;
    }

    public static Relic makeRelic(class_1799 stack) {
        return new RelicImpl(stack, null);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.field_9236 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null) {
                relic.tickBinding(player);
            }
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        return super.method_7878(toRepair, repair);
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.extrabotany.excalibur").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        RelicImpl.addDefaultTooltip((class_1799)stack, tooltip);
    }

    public static boolean isSaber(class_1799 stack) {
        String name = stack.method_7964().getString().toLowerCase(Locale.ROOT).trim();
        return "saber".equals(name);
    }
}

