/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic;

import io.github.lounode.extrabotany.api.entity.EntityNbtHelper;
import io.github.lounode.extrabotany.common.entity.MagicArrowEntity;
import io.github.lounode.extrabotany.common.item.enchantment.ICustomEnchantable;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1613;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.LensEffectItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.equipment.tool.bow.LivingwoodBowItem;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.xplat.XplatAbstractions;

public class FailnaughtItem
extends LivingwoodBowItem
implements LensEffectItem,
ICustomEnchantable {
    private static final float ADVANCEMENT_REQUIRE = 100.0f;
    private static final float ATTACK_BOX_RADIUS = 2.0f;
    private static final int HIT_ENTITY_COST = 50;
    public static final float MINIMUM_SHOOT_PROCESS = 0.1f;
    public static final float[] TIER_PROCESS = new float[]{0.0f, 0.0f, 0.35f, 0.7f, 0.9f};
    public static final int[] MANA_PER_USE_MAX = new int[]{0, 350, 500, 650, 800};
    private static final List<class_1887> SUPPORT_ENCHANTMENTS = Arrays.asList(class_1893.field_9103, class_1893.field_9116, class_1893.field_9126, class_1893.field_9108, class_1893.field_9098, class_1893.field_9109);
    private static final float DEFAULT_CHARGE_SPEED = 0.25f;
    private static final float QUICK_CHARGE_BONUS_PER_LEVEL = 0.1f;

    public FailnaughtItem(class_1792.class_1793 props) {
        super(props);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        int multiShoutLevel = class_1890.method_8225((class_1887)class_1893.field_9108, (class_1799)itemstack);
        float chargeProgress = this.getChargeProcess(itemstack, (class_1309)player);
        boolean flag = false;
        Relic relic = XplatAbstractions.INSTANCE.findRelic(itemstack);
        if (relic != null && relic.isRightPlayer(player) && ManaItemHandler.instance().requestManaExactForTool(itemstack, player, this.getManaForUse(chargeProgress) * (multiShoutLevel > 1 ? 3 : 1), false)) {
            flag = true;
        }
        if (!player.method_31549().field_7477 && !flag) {
            return class_1271.method_22431((Object)itemstack);
        }
        player.method_6019(hand);
        return class_1271.method_22428((Object)itemstack);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 livingEntity, int timeLeft) {
        if (world.method_8608()) {
            return;
        }
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            float chargeProgress = this.getChargeProcess(stack, (class_1309)player);
            int quickChargeLevel = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack);
            if (quickChargeLevel > 0) {
                ManaItemHandler.instance().requestManaExactForTool(stack, player, 100 * quickChargeLevel, true);
            }
            if (chargeProgress < 0.1f) {
                return;
            }
            int multiShoutLevel = class_1890.method_8225((class_1887)class_1893.field_9108, (class_1799)stack);
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null && relic.isRightPlayer(player) && (player.method_31549().field_7477 || ManaItemHandler.instance().requestManaExactForTool(stack, player, this.getManaForUse(chargeProgress) * (multiShoutLevel > 1 ? 3 : 1), true))) {
                int manaInBurst = this.getManaForUse(chargeProgress) * (multiShoutLevel > 1 ? 3 : 1);
                float spreadAngle = 10.0f;
                for (int i = 0; i < (multiShoutLevel > 0 ? 3 : 1); ++i) {
                    ManaBurstEntity burst = this.getBurst(player, stack, manaInBurst, this.getTier(chargeProgress));
                    if (multiShoutLevel > 0 && i > 0) {
                        float angle = (i == 1 ? -spreadAngle : spreadAngle) * ((float)Math.PI / 180);
                        burst.method_18799(burst.method_18798().method_1024(angle));
                    }
                    player.method_37908().method_8649((class_1297)burst);
                }
                player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), ExtraBotanySounds.FAILNAUGHT_SHOOT, class_3419.field_15248, 1.0f, 1.0f);
            }
        }
    }

    public ManaBurstEntity getBurst(class_1657 player, class_1799 stack, int mana, int tier) {
        MagicArrowEntity burst = new MagicArrowEntity(player);
        float motionModifier = 7.0f;
        burst.setColor(0x20FF20);
        burst.setMana(mana);
        burst.setStartingMana(mana);
        burst.setManaLossPerTick((float)MANA_PER_USE_MAX[tier] / 87.5f);
        burst.setGravity(0.0f);
        burst.method_18799(burst.method_18798().method_1021((double)motionModifier));
        burst.setSourceLens(stack.method_7972());
        float chargeProcess = this.getChargeProcess(stack, (class_1309)player);
        float tierProcess = this.getProcessInTier(chargeProcess);
        float baseDamage = 10.0f;
        int powerLevel = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)stack);
        if (powerLevel > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, 50 * powerLevel, true)) {
            baseDamage = baseDamage + 0.5f + 0.5f * (float)powerLevel;
        }
        float damage = baseDamage * ((float)tier * tierProcess);
        burst.setDamage(damage);
        return burst;
    }

    public void apply(class_1799 stack, BurstProperties props, class_1937 level) {
    }

    public boolean collideBurst(ManaBurst burst, class_239 pos, boolean isManaBlock, boolean shouldKill, class_1799 stack) {
        return shouldKill;
    }

    public void updateBurst(ManaBurst burst, class_1799 stack) {
        class_1657 player;
        class_1297 thrower;
        class_1682 entity;
        block9: {
            block8: {
                entity = burst.entity();
                if (entity.method_37908().method_8608()) {
                    return;
                }
                thrower = entity.method_24921();
                if (!(thrower instanceof class_1657)) break block8;
                player = (class_1657)thrower;
                if (thrower.method_5805()) break block9;
            }
            entity.method_31472();
            return;
        }
        class_238 axis = new class_238(entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.field_6038, entity.field_5971, entity.field_5989).method_1014(2.0);
        List<class_1309> entities = entity.method_37908().method_18467(class_1309.class, axis).stream().filter(e -> e != thrower).filter(e -> {
            class_1657 other;
            return !(e instanceof class_1657 && !player.method_7256(other = (class_1657)e));
        }).filter(e -> e.field_6235 == 0).toList();
        float chargeProcess = this.getChargeProcess(stack, (class_1309)player);
        int tier = this.getTier(chargeProcess);
        float tierProcess = this.getProcessInTier(chargeProcess);
        for (class_1309 living : entities) {
            float fz;
            float fx;
            float horizontalDistanceSq;
            class_1613 skeleton;
            int mana = burst.getMana();
            if (mana < 50) {
                return;
            }
            burst.setMana(mana - 50);
            float damage = EntityNbtHelper.getNBT((class_1297)entity).method_10583("Damage");
            class_1282 source = player.method_48923().method_48802(player);
            living.method_5643(source, damage);
            int punchLevel = class_1890.method_8225((class_1887)class_1893.field_9116, (class_1799)stack);
            if (punchLevel > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, 20 * punchLevel, true)) {
                living.method_6005((double)((float)punchLevel * 0.5f), entity.method_23317() - living.method_23317(), entity.method_23321() - living.method_23321());
            }
            if (class_1890.method_8225((class_1887)class_1893.field_9126, (class_1799)stack) > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, 10, true)) {
                living.method_5639(100);
            }
            if (!(living instanceof class_1613) || (skeleton = (class_1613)living).method_5805() || !((horizontalDistanceSq = class_3532.method_15355((float)((fx = (float)(player.method_23317() - living.method_23317())) * fx + (fz = (float)(player.method_23321() - living.method_23321())) * fz))) > 100.0f)) continue;
            PlayerHelper.grantCriterion((class_3222)((class_3222)player), (class_2960)ResourceLocationHelper.prefix("main/hundred_block_pierce"), (String)"code_triggered");
        }
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public float chargeVelocityMultiplier(class_1799 itemStack, class_1309 livingEntity) {
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            int quickChargeLevel = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)itemStack);
            if (ManaItemHandler.instance().requestManaExactForTool(itemStack, player, 100 * quickChargeLevel, false)) {
                return 0.25f + 0.1f * (float)quickChargeLevel;
            }
        }
        return 0.25f;
    }

    public boolean doParticles(ManaBurst burst, class_1799 stack) {
        return true;
    }

    public float getChargeProcess(class_1799 stack, class_1309 entity) {
        return class_3532.method_15363((float)((float)(this.method_7881(stack) - entity.method_6014()) * this.chargeVelocityMultiplier(stack, entity) / 20.0f), (float)0.0f, (float)1.0f);
    }

    public int getTier(float chargeProcess) {
        if ((chargeProcess = class_3532.method_15363((float)chargeProcess, (float)0.0f, (float)1.0f)) < TIER_PROCESS[2]) {
            return 1;
        }
        if (chargeProcess < TIER_PROCESS[3]) {
            return 2;
        }
        if (chargeProcess < TIER_PROCESS[4]) {
            return 3;
        }
        return 4;
    }

    public float getProcessInTier(float chargeProcess) {
        return switch (this.getTier(chargeProcess)) {
            case 1 -> chargeProcess / TIER_PROCESS[2];
            case 2 -> (chargeProcess - TIER_PROCESS[2]) / (TIER_PROCESS[3] - TIER_PROCESS[2]);
            case 3 -> (chargeProcess - TIER_PROCESS[3]) / (TIER_PROCESS[4] - TIER_PROCESS[3]);
            case 4 -> (chargeProcess - TIER_PROCESS[4]) / (1.0f - TIER_PROCESS[4]);
            default -> 0.0f;
        };
    }

    public int getManaForUse(float chargeProcess) {
        chargeProcess = class_3532.method_15363((float)chargeProcess, (float)0.0f, (float)1.0f);
        int tier = this.getTier(chargeProcess);
        float tierProcess = this.getProcessInTier(chargeProcess);
        return switch (tier) {
            case 1 -> (int)((float)MANA_PER_USE_MAX[1] * tierProcess);
            case 2 -> (int)((float)MANA_PER_USE_MAX[1] + (float)(MANA_PER_USE_MAX[2] - MANA_PER_USE_MAX[1]) * tierProcess);
            case 3 -> (int)((float)MANA_PER_USE_MAX[2] + (float)(MANA_PER_USE_MAX[3] - MANA_PER_USE_MAX[2]) * tierProcess);
            case 4 -> (int)((float)MANA_PER_USE_MAX[3] + (float)(MANA_PER_USE_MAX[4] - MANA_PER_USE_MAX[3]) * tierProcess);
            default -> 0;
        };
    }

    public <T extends class_1309> int damageItem(class_1799 stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.field_9236 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null) {
                relic.tickBinding(player);
            }
        }
    }

    public boolean method_7878(class_1799 bow, class_1799 material) {
        return false;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 flags) {
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.extrabotany.failnaught").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        RelicImpl.addDefaultTooltip((class_1799)stack, tooltip);
    }

    public static Relic makeRelic(class_1799 stack) {
        return new RelicImpl(stack, null);
    }

    public boolean method_7870(class_1799 pStack) {
        return true;
    }

    public int method_7837() {
        return 30;
    }

    @Override
    public boolean canEnchant(class_1799 stack, class_1887 enchantment) {
        return SUPPORT_ENCHANTMENTS.contains(enchantment);
    }

    @Override
    public boolean canEnchantOnTable(class_1799 stack, class_1887 enchantment) {
        return SUPPORT_ENCHANTMENTS.contains(enchantment);
    }
}

