/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic;

import io.github.lounode.extrabotany.common.advancements.ManaChargeTrigger;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5632;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.relic.RelicBaubleItem;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.xplat.XplatAbstractions;

public class MasterBandOfManaItem
extends RelicBaubleItem
implements CustomCreativeTabContents {
    protected static final long MAX_MANA = Long.MAX_VALUE;
    public static final long ADVANCEMENT_PHASE1_REQUIRE = Integer.MAX_VALUE;
    public static final long ADVANCEMENT_PHASE2_REQUIRE = Long.MAX_VALUE;
    private static final String TAG_MANA = "mana";

    public MasterBandOfManaItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public void addToCreativeTab(class_1792 me, class_1761.class_7704 output) {
        output.method_45421((class_1935)this);
        class_1799 full = new class_1799((class_1935)this);
        MasterBandOfManaItem.setMana(full, Long.MAX_VALUE);
        output.method_45420(full);
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.of(new ManaBarTooltip(this.getFractionForDisplay(stack)));
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
        super.method_7851(stack, world, tooltip, flags);
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        String manaString = this.getManaItem(stack).getRealMana() + "/" + this.getManaItem(stack).getRealMaxMana();
        tooltip.add((class_2561)class_2561.method_43469((String)"message.extrabotany.actionbar.mana_left", (Object[])new Object[]{manaString}).method_27692(class_124.field_1080));
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean held) {
        super.method_7888(stack, world, entity, slot, held);
        if (!world.field_9236 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null && relic.isRightPlayer(player) && player.field_6012 % 10 == 0) {
                ExtendManaItemImpl manaItem = this.getManaItem(stack);
                ManaChargeTrigger.INSTANCE.trigger((class_3222)player, stack, manaItem.getRealMana());
            }
        }
    }

    protected static void setMana(class_1799 stack, long mana) {
        if (mana > 0L) {
            ItemNBTHelper.setLong((class_1799)stack, (String)TAG_MANA, (long)mana);
        } else {
            ItemNBTHelper.removeEntry((class_1799)stack, (String)TAG_MANA);
        }
    }

    public static Relic makeRelic(class_1799 stack) {
        return new RelicImpl(stack, ResourceLocationHelper.prefix("panda_do_not_wear_rings"));
    }

    public boolean method_31567(class_1799 stack) {
        return false;
    }

    public int method_31569(class_1799 stack) {
        return Math.round(13.0f * this.getFractionForDisplay(stack));
    }

    public int method_31571(class_1799 stack) {
        return class_3532.method_15369((float)(this.getFractionForDisplay(stack) / 3.0f), (float)1.0f, (float)1.0f);
    }

    private ExtendManaItemImpl getManaItem(class_1799 stack) {
        return (ExtendManaItemImpl)XplatAbstractions.INSTANCE.findManaItem(stack);
    }

    private float getFractionForDisplay(class_1799 stack) {
        long mana = this.getManaItem(stack).getRealMana();
        long max = this.getManaItem(stack).getRealMaxMana();
        return (float)mana / (float)max;
    }

    public static class ExtendManaItemImpl
    implements ManaItem {
        protected final class_1799 stack;

        public ExtendManaItemImpl(class_1799 stack) {
            this.stack = stack;
        }

        public int getMana() {
            int maxCharge;
            long mana = this.getRealMana();
            if (mana > (long)(Integer.MAX_VALUE - (maxCharge = 100000000))) {
                if (mana < Long.MAX_VALUE - (long)maxCharge) {
                    return Integer.MAX_VALUE - maxCharge;
                }
                return Integer.MAX_VALUE - (int)(this.getRealMaxMana() - mana);
            }
            return (int)mana;
        }

        public long getRealMana() {
            return ItemNBTHelper.getLong((class_1799)this.stack, (String)MasterBandOfManaItem.TAG_MANA, (long)0L);
        }

        public int getMaxMana() {
            return Integer.MAX_VALUE;
        }

        public long getRealMaxMana() {
            return Long.MAX_VALUE;
        }

        public void addMana(int mana) {
            long current = this.getRealMana();
            if (mana > 0) {
                long maxAdd = Long.MAX_VALUE - current;
                current = (long)mana > maxAdd ? Long.MAX_VALUE : current + (long)mana;
            } else if (mana < 0) {
                long minSub = current - Long.MIN_VALUE;
                current = (long)(-mana) > minSub ? current + (long)mana : Long.MIN_VALUE;
            }
            long realMax = this.getRealMaxMana();
            long clamped = current < 0L ? 0L : Math.min(current, realMax);
            MasterBandOfManaItem.setMana(this.stack, clamped);
        }

        public boolean canReceiveManaFromPool(class_2586 pool) {
            return true;
        }

        public boolean canReceiveManaFromItem(class_1799 otherStack) {
            return true;
        }

        public boolean canExportManaToPool(class_2586 pool) {
            return true;
        }

        public boolean canExportManaToItem(class_1799 otherStack) {
            return true;
        }

        public boolean isNoExport() {
            return false;
        }
    }
}

