/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic.void_archives;

import io.github.lounode.extrabotany.api.ExtraBotanyAPI;
import io.github.lounode.extrabotany.api.item.VoidArchivesVariant;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.relic.void_archives.variants.Camera;
import io.github.lounode.extrabotany.common.item.relic.void_archives.variants.Excalibur;
import io.github.lounode.extrabotany.common.item.relic.void_archives.variants.Failnaught;
import io.github.lounode.extrabotany.common.item.relic.void_archives.variants.FruitOfGrisaia;
import io.github.lounode.extrabotany.common.item.relic.void_archives.variants.InfiniteWine;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.xplat.XplatAbstractions;

public class VoidArchivesItem
extends class_1792
implements CustomCreativeTabContents {
    private static final String TAG_VARIANT = "variant";
    public static final int KEEP_VARIANT_REQUIRE = 500;

    public VoidArchivesItem(class_1792.class_1793 properties) {
        super(properties);
        ExtraBotanyAPI.instance().registerVoidArchivesVariant(VoidArchivesVariant.DEFAULT);
        ExtraBotanyAPI.instance().registerVoidArchivesVariant(FruitOfGrisaia.INSTANCE);
        ExtraBotanyAPI.instance().registerVoidArchivesVariant(InfiniteWine.INSTANCE);
        ExtraBotanyAPI.instance().registerVoidArchivesVariant(Excalibur.INSTANCE);
        ExtraBotanyAPI.instance().registerVoidArchivesVariant(Failnaught.INSTANCE);
        ExtraBotanyAPI.instance().registerVoidArchivesVariant(Camera.INSTANCE);
    }

    public void addToCreativeTab(class_1792 item, class_1761.class_7704 output) {
        output.method_45420(VoidArchivesItem.getDefaultItemStack());
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 stack = player.method_5998(usedHand);
        if (player.method_5715()) {
            VoidArchivesItem.switchVariant(stack);
            return super.method_7836(level, player, usedHand);
        }
        return VoidArchivesItem.getVariant(stack).use(level, player, usedHand);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        super.method_7851(stack, level, tooltipComponents, isAdvanced);
        RelicImpl.addDefaultTooltip((class_1799)stack, tooltipComponents);
        VoidArchivesItem.getVariant(stack).appendHoverText(stack, level, tooltipComponents, isAdvanced);
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        if (!level.field_9236 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null) {
                relic.tickBinding(player);
            }
            if (VoidArchivesItem.getVariant(stack) != VoidArchivesVariant.DEFAULT && !ManaItemHandler.instance().requestManaExactForTool(stack, player, this.getKeepVariantRequire(), true)) {
                VoidArchivesItem.setVariant(stack, VoidArchivesVariant.DEFAULT);
            }
        }
        super.method_7888(stack, level, entity, slotId, isSelected);
        VoidArchivesItem.getVariant(stack).inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public static void switchVariant(class_1799 stack) {
        if (!(stack.method_7909() instanceof VoidArchivesItem)) {
            return;
        }
        Map<String, VoidArchivesVariant> variants = ExtraBotanyAPI.instance().getVoidArchivesVariants();
        VoidArchivesVariant current = VoidArchivesItem.getVariant(stack);
        int index = new ArrayList<String>(variants.keySet()).indexOf(current.getId());
        int nextIndex = (index + 1) % variants.size();
        String nextKey = new ArrayList<String>(variants.keySet()).get(nextIndex);
        VoidArchivesVariant nextVariant = variants.get(nextKey);
        VoidArchivesItem.setVariant(stack, nextVariant);
    }

    public static void setVariant(class_1799 stack, VoidArchivesVariant variant) {
        if (!(stack.method_7909() instanceof VoidArchivesItem)) {
            return;
        }
        VoidArchivesVariant current = VoidArchivesItem.getVariant(stack);
        current.onInactive(stack);
        ItemNBTHelper.setString((class_1799)stack, (String)TAG_VARIANT, (String)variant.getId());
        variant.onActive(stack);
    }

    public static VoidArchivesVariant getVariant(class_1799 stack) {
        String variantString = ItemNBTHelper.getString((class_1799)stack, (String)TAG_VARIANT, (String)VoidArchivesVariant.DEFAULT.getId());
        return ExtraBotanyAPI.instance().getVoidArchivesVariants().getOrDefault(variantString, VoidArchivesVariant.DEFAULT);
    }

    public static String getTagVariant(class_1799 stack) {
        return ItemNBTHelper.getString((class_1799)stack, (String)TAG_VARIANT, (String)VoidArchivesVariant.DEFAULT.getId());
    }

    public static int getVariantIndex(class_1799 stack) {
        if (!(stack.method_7909() instanceof VoidArchivesItem)) {
            return -1;
        }
        Map<String, VoidArchivesVariant> variants = ExtraBotanyAPI.instance().getVoidArchivesVariants();
        VoidArchivesVariant current = VoidArchivesItem.getVariant(stack);
        return new ArrayList<String>(variants.keySet()).indexOf(current.getId());
    }

    public static class_1799 getDefaultItemStack() {
        class_1799 defaultStack = new class_1799((class_1935)ExtraBotanyItems.voidArchives);
        ItemNBTHelper.setString((class_1799)defaultStack, (String)TAG_VARIANT, (String)VoidArchivesVariant.DEFAULT.getId());
        return defaultStack;
    }

    public int getKeepVariantRequire() {
        return 500;
    }

    public class_1799 method_7854() {
        return VoidArchivesItem.getDefaultItemStack();
    }

    public static Relic makeRelic(class_1799 stack) {
        return new RelicImpl(stack, ResourceLocationHelper.prefix("the_original_divine_key"));
    }

    public void method_7852(class_1937 level, class_1309 livingEntity, class_1799 stack, int remainingUseDuration) {
        super.method_7852(level, livingEntity, stack, remainingUseDuration);
        VoidArchivesItem.getVariant(stack).onUseTick(level, livingEntity, stack, remainingUseDuration);
    }

    public void method_33261(class_1542 itemEntity) {
        super.method_33261(itemEntity);
        VoidArchivesItem.getVariant(itemEntity.method_6983()).onDestroyed(itemEntity);
    }

    public class_1269 method_7884(class_1838 context) {
        return VoidArchivesItem.getVariant(context.method_8041()).useOn(context);
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        return VoidArchivesItem.getVariant(stack).getDestroySpeed(stack, state);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 level, class_1309 livingEntity) {
        return VoidArchivesItem.getVariant(stack).finishUsingItem(stack, level, livingEntity);
    }

    public boolean method_31566(class_1799 stack, class_1799 other, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        return VoidArchivesItem.getVariant(stack).overrideOtherStackedOnMe(stack, other, slot, action, player, access);
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 action, class_1657 player) {
        return VoidArchivesItem.getVariant(stack).overrideStackedOnOther(stack, slot, action, player);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        return VoidArchivesItem.getVariant(stack).hurtEnemy(stack, target, attacker);
    }

    public boolean method_7879(class_1799 stack, class_1937 level, class_2680 state, class_2338 pos, class_1309 miningEntity) {
        return VoidArchivesItem.getVariant(stack).mineBlock(stack, level, state, pos, miningEntity);
    }

    public int method_7881(class_1799 stack) {
        return VoidArchivesItem.getVariant(stack).getUseDuration(stack);
    }

    public class_1839 method_7853(class_1799 stack) {
        return VoidArchivesItem.getVariant(stack).getUseAnimation(stack);
    }

    public void method_7840(class_1799 stack, class_1937 level, class_1309 livingEntity, int timeCharged) {
        VoidArchivesItem.getVariant(stack).releaseUsing(stack, level, livingEntity, timeCharged);
    }

    public boolean method_7838(class_1799 stack) {
        return VoidArchivesItem.getVariant(stack).useOnRelease(stack);
    }
}

