/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic.void_archives.variants;

import io.github.lounode.extrabotany.api.item.VoidArchivesVariant;
import io.github.lounode.extrabotany.common.entity.MagicArrowEntity;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2499;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class Failnaught
implements VoidArchivesVariant {
    public static Failnaught INSTANCE = new Failnaught();
    private static final String ID = "failnaught";
    public static final float[] TIER_PROCESS = new float[]{0.0f, 0.0f, 0.35f, 0.7f, 0.9f};
    public static final int[] MANA_PER_USE_MAX = new int[]{0, 350, 500, 650, 800};
    private static final float DEFAULT_CHARGE_SPEED = 0.25f;
    private static final float QUICK_CHARGE_BONUS_PER_LEVEL = 0.1f;
    public static final float MINIMUM_SHOOT_PROCESS = 0.1f;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public class_1271<class_1799> use(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        int multiShoutLevel = class_1890.method_8225((class_1887)class_1893.field_9108, (class_1799)itemstack);
        float chargeProgress = this.getChargeProcess(itemstack, (class_1309)player);
        boolean flag = false;
        Relic relic = XplatAbstractions.INSTANCE.findRelic(itemstack);
        if (relic != null && relic.isRightPlayer(player) && ManaItemHandler.instance().requestManaExactForTool(itemstack, player, this.getManaForUse(chargeProgress) * (multiShoutLevel > 1 ? 3 : 1), false)) {
            flag = true;
        }
        if (!player.method_31549().field_7477 && !flag) {
            return class_1271.method_22431((Object)itemstack);
        }
        player.method_6019(hand);
        return class_1271.method_22428((Object)itemstack);
    }

    @Override
    public void releaseUsing(class_1799 stack, class_1937 level, class_1309 livingEntity, int timeCharged) {
        if (level.method_8608()) {
            return;
        }
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            float chargeProgress = this.getChargeProcess(stack, (class_1309)player);
            int quickChargeLevel = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack);
            if (quickChargeLevel > 0) {
                ManaItemHandler.instance().requestManaExactForTool(stack, player, 100 * quickChargeLevel, true);
            }
            if (chargeProgress < 0.1f) {
                return;
            }
            int multiShoutLevel = class_1890.method_8225((class_1887)class_1893.field_9108, (class_1799)stack);
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null && relic.isRightPlayer(player) && (player.method_31549().field_7477 || ManaItemHandler.instance().requestManaExactForTool(stack, player, this.getManaForUse(chargeProgress) * (multiShoutLevel > 1 ? 3 : 1), true))) {
                int manaInBurst = this.getManaForUse(chargeProgress) * (multiShoutLevel > 1 ? 3 : 1);
                float spreadAngle = 10.0f;
                for (int i = 0; i < (multiShoutLevel > 0 ? 3 : 1); ++i) {
                    ManaBurstEntity burst = this.getBurst(player, stack, manaInBurst, this.getTier(chargeProgress));
                    if (multiShoutLevel > 0 && i > 0) {
                        float angle = (i == 1 ? -spreadAngle : spreadAngle) * ((float)Math.PI / 180);
                        burst.method_18799(burst.method_18798().method_1024(angle));
                    }
                    player.method_37908().method_8649((class_1297)burst);
                }
                player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), ExtraBotanySounds.FAILNAUGHT_SHOOT, class_3419.field_15248, 1.0f, 1.0f);
            }
        }
    }

    public ManaBurstEntity getBurst(class_1657 player, class_1799 stack, int mana, int tier) {
        MagicArrowEntity burst = new MagicArrowEntity(player);
        float motionModifier = 7.0f;
        burst.setColor(0x20FF20);
        burst.setMana(mana);
        burst.setStartingMana(mana);
        burst.setManaLossPerTick((float)MANA_PER_USE_MAX[tier] / 87.5f);
        burst.setGravity(0.0f);
        burst.method_18799(burst.method_18798().method_1021((double)motionModifier));
        class_1799 lens = new class_1799((class_1935)ExtraBotanyItems.failnaught);
        class_2499 enchants = ItemNBTHelper.getList((class_1799)stack, (String)"Enchantments", (int)10, (boolean)true);
        if (enchants != null) {
            ItemNBTHelper.setList((class_1799)lens, (String)"Enchantments", (class_2499)enchants.method_10612());
        }
        burst.setSourceLens(lens);
        float chargeProcess = this.getChargeProcess(stack, (class_1309)player);
        float tierProcess = this.getProcessInTier(chargeProcess);
        float baseDamage = 10.0f;
        int powerLevel = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)stack);
        if (powerLevel > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, 50 * powerLevel, true)) {
            baseDamage = baseDamage + 0.5f + 0.5f * (float)powerLevel;
        }
        float damage = baseDamage * ((float)tier * tierProcess);
        burst.setDamage(damage);
        return burst;
    }

    public float getChargeProcess(class_1799 stack, class_1309 entity) {
        return class_3532.method_15363((float)((float)(this.getUseDuration(stack) - entity.method_6014()) * this.chargeVelocityMultiplier(stack, entity) / 20.0f), (float)0.0f, (float)1.0f);
    }

    public int getTier(float chargeProcess) {
        if ((chargeProcess = class_3532.method_15363((float)chargeProcess, (float)0.0f, (float)1.0f)) < TIER_PROCESS[2]) {
            return 1;
        }
        if (chargeProcess < TIER_PROCESS[3]) {
            return 2;
        }
        if (chargeProcess < TIER_PROCESS[4]) {
            return 3;
        }
        return 4;
    }

    public float getProcessInTier(float chargeProcess) {
        return switch (this.getTier(chargeProcess)) {
            case 1 -> chargeProcess / TIER_PROCESS[2];
            case 2 -> (chargeProcess - TIER_PROCESS[2]) / (TIER_PROCESS[3] - TIER_PROCESS[2]);
            case 3 -> (chargeProcess - TIER_PROCESS[3]) / (TIER_PROCESS[4] - TIER_PROCESS[3]);
            case 4 -> (chargeProcess - TIER_PROCESS[4]) / (1.0f - TIER_PROCESS[4]);
            default -> 0.0f;
        };
    }

    public int getManaForUse(float chargeProcess) {
        chargeProcess = class_3532.method_15363((float)chargeProcess, (float)0.0f, (float)1.0f);
        int tier = this.getTier(chargeProcess);
        float tierProcess = this.getProcessInTier(chargeProcess);
        return switch (tier) {
            case 1 -> (int)((float)MANA_PER_USE_MAX[1] * tierProcess);
            case 2 -> (int)((float)MANA_PER_USE_MAX[1] + (float)(MANA_PER_USE_MAX[2] - MANA_PER_USE_MAX[1]) * tierProcess);
            case 3 -> (int)((float)MANA_PER_USE_MAX[2] + (float)(MANA_PER_USE_MAX[3] - MANA_PER_USE_MAX[2]) * tierProcess);
            case 4 -> (int)((float)MANA_PER_USE_MAX[3] + (float)(MANA_PER_USE_MAX[4] - MANA_PER_USE_MAX[3]) * tierProcess);
            default -> 0;
        };
    }

    public float chargeVelocityMultiplier(class_1799 itemStack, class_1309 livingEntity) {
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            int quickChargeLevel = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)itemStack);
            if (ManaItemHandler.instance().requestManaExactForTool(itemStack, player, 100 * quickChargeLevel, false)) {
                return 0.25f + 0.1f * (float)quickChargeLevel;
            }
        }
        return 0.25f;
    }

    @Override
    public int getUseDuration(class_1799 stack) {
        return 72000;
    }

    @Override
    public class_1839 getUseAnimation(class_1799 stack) {
        return class_1839.field_8953;
    }
}

