/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic.voidcore;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.github.lounode.eventwrapper.event.entity.living.LivingAttackEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.LivingDamageEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.LivingEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.LivingHurtEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.MobEffectEventWrapper;
import io.github.lounode.eventwrapper.event.entity.player.PlayerEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.api.ExtraBotanyAPI;
import io.github.lounode.extrabotany.api.item.CoreOfTheVoidVariant;
import io.github.lounode.extrabotany.common.ExtraBotanyDamageTypes;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.relic.voidcore.variants.Flandre;
import io.github.lounode.extrabotany.common.item.relic.voidcore.variants.Herrscher;
import io.github.lounode.extrabotany.common.item.relic.voidcore.variants.Jim;
import io.github.lounode.extrabotany.common.item.relic.voidcore.variants.Steampunk;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import io.github.lounode.extrabotany.common.util.SoundEventUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import net.minecraft.class_4081;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5134;
import net.minecraft.class_5455;
import net.minecraft.class_572;
import net.minecraft.class_8103;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.xplat.XplatAbstractions;

@EventBusSubscriberWrapper
public class CoreOfTheVoidItem
extends BaubleItem
implements CustomCreativeTabContents {
    private static final String TAG_VARIANT = "variant";
    private static final int FLY_COST = 100;
    private static final int CURE_COST = 200;
    private static final int BACKFIRE_THRESHOLD = 100;
    private static final float BACKFIRE_DAMAGE = 2.0f;
    private static final List<String> playersWithFlight = Collections.synchronizedList(new ArrayList());

    public CoreOfTheVoidItem(class_1792.class_1793 properties) {
        super(properties);
        ExtraBotanyAPI.instance().registerCOVVariant(new Herrscher());
        ExtraBotanyAPI.instance().registerCOVVariant(new Flandre());
        ExtraBotanyAPI.instance().registerCOVVariant(new Jim());
        ExtraBotanyAPI.instance().registerCOVVariant(new Steampunk());
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register((class_1792)this, (AccessoryRenderer)new Renderer()));
    }

    public void addToCreativeTab(class_1792 me, class_1761.class_7704 output) {
        Map<String, CoreOfTheVoidVariant> variants = ExtraBotanyAPI.instance().getCOVVariants();
        for (CoreOfTheVoidVariant variant : variants.values()) {
            class_1799 stack = new class_1799((class_1935)this);
            ItemNBTHelper.setString((class_1799)stack, (String)TAG_VARIANT, (String)variant.getId());
            output.method_45420(stack);
        }
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flags) {
        super.method_7851(stack, world, tooltip, flags);
        RelicImpl.addDefaultTooltip((class_1799)stack, tooltip);
        tooltip.add((class_2561)class_2561.method_43471((String)("extrabotany.wings." + CoreOfTheVoidItem.getVariant(stack))));
    }

    @SubscribeEventWrapper
    public static void updatePlayerFlyStatus(LivingEventWrapper.LivingTickEvent event) {
        class_1309 class_13092 = event.getEntity();
        if (!(class_13092 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_13092;
        class_1799 tiara = EquipmentHandler.findOrEmpty((class_1792)ExtraBotanyItems.coreOfTheVoid, (class_1309)player);
        if (playersWithFlight.contains(CoreOfTheVoidItem.playerStr(player))) {
            if (CoreOfTheVoidItem.shouldPlayerHaveFlight(player)) {
                player.method_31549().field_7478 = true;
                if (player.method_31549().field_7479 && !player.method_37908().field_9236 && !player.method_7337() && !player.method_7325()) {
                    ManaItemHandler.instance().requestManaExact(tiara, player, CoreOfTheVoidItem.getFlyCost(), true);
                }
            } else {
                if (!player.method_7325() && !player.method_31549().field_7477) {
                    player.method_31549().field_7478 = false;
                    player.method_31549().field_7479 = false;
                    player.method_31549().field_7480 = false;
                }
                playersWithFlight.remove(CoreOfTheVoidItem.playerStr(player));
            }
        } else if (CoreOfTheVoidItem.shouldPlayerHaveFlight(player)) {
            playersWithFlight.add(CoreOfTheVoidItem.playerStr(player));
            player.method_31549().field_7478 = true;
        }
    }

    public void onWornTick(class_1799 stack, class_1309 entity) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        if (CoreOfTheVoidItem.shouldBackFire(stack, entity) && entity.field_6012 % 10 == 0) {
            if (entity.method_5643(this.damageSource(entity.method_37908().method_30349()), this.getBackfireDamage()) && entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                player.method_17356(ExtraBotanySounds.PLAYER_BACKFIRE, class_3419.field_15248, 1.0f, SoundEventUtil.randomPitch(player.method_37908()));
            }
            return;
        }
        this.tryRemoveHarmfulPotion(stack, entity);
    }

    @SubscribeEventWrapper
    public static void playerLoggedOut(PlayerEventWrapper.PlayerLoggedOutEvent event) {
        String username = event.getEntity().method_7334().getName();
        playersWithFlight.remove(username + ":false");
        playersWithFlight.remove(username + ":true");
    }

    private static boolean shouldPlayerHaveFlight(class_1657 player) {
        class_1799 armor = EquipmentHandler.findOrEmpty((class_1792)ExtraBotanyItems.coreOfTheVoid, (class_1309)player);
        if (!armor.method_7960()) {
            Relic relic = XplatAbstractions.INSTANCE.findRelic(armor);
            return relic != null && relic.isRightPlayer(player) && ManaItemHandler.instance().requestManaExact(armor, player, CoreOfTheVoidItem.getFlyCost(), false);
        }
        return false;
    }

    private static String playerStr(class_1657 player) {
        return player.method_7334().getName() + ":" + player.method_37908().field_9236;
    }

    public static boolean shouldBackFire(class_1799 stack, class_1309 entity) {
        class_1657 player;
        return entity instanceof class_1657 && !(player = (class_1657)entity).method_7337() && !player.method_7325() && !ManaItemHandler.instance().requestManaExactForTool(stack, player, CoreOfTheVoidItem.getBackfireThreshold(), false);
    }

    public static int getFlyCost() {
        return 100;
    }

    public static int getCureCost() {
        return 200;
    }

    public static int getBackfireThreshold() {
        return 100;
    }

    public float getBackfireDamage() {
        return 2.0f;
    }

    public static String getVariant(class_1799 stack) {
        return ItemNBTHelper.getString((class_1799)stack, (String)TAG_VARIANT, (String)"herrscher");
    }

    public class_1282 damageSource(class_5455 access) {
        return ExtraBotanyDamageTypes.Sources.backfireDamage(access);
    }

    public boolean hasRender(class_1799 stack, class_1309 living) {
        return super.hasRender(stack, living) && living instanceof class_1657;
    }

    public static Relic makeRelic(class_1799 stack) {
        return new RelicImpl(stack, null);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.field_9236 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null) {
                relic.tickBinding(player);
            }
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    public Multimap<class_1320, class_1322> getEquippedAttributeModifiers(class_1799 stack) {
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)class_5134.field_23719, (Object)new class_1322(CoreOfTheVoidItem.getBaubleUUID((class_1799)stack), "Core of The Void", (double)0.1f, class_1322.class_1323.field_6328));
        attributes.put((Object)class_5134.field_23720, (Object)new class_1322(CoreOfTheVoidItem.getBaubleUUID((class_1799)stack), "Core of The Void", (double)0.6f, class_1322.class_1323.field_6328));
        return attributes;
    }

    @SubscribeEventWrapper
    public static void onLivingAttack(LivingAttackEventWrapper event) {
        class_1657 player;
        class_1309 owner = event.getEntity();
        class_1799 armor = EquipmentHandler.findOrEmpty((class_1792)ExtraBotanyItems.coreOfTheVoid, (class_1309)owner);
        if (armor.method_7960()) {
            return;
        }
        Relic relic = XplatAbstractions.INSTANCE.findRelic(armor);
        if (relic == null || !(owner instanceof class_1657) || !relic.isRightPlayer(player = (class_1657)owner) || CoreOfTheVoidItem.shouldBackFire(armor, (class_1309)player)) {
            return;
        }
        if (event.getSource().method_48789(class_8103.field_42247)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEventWrapper
    public static void onLivingHurt(LivingHurtEventWrapper event) {
        class_1657 player;
        class_1309 owner = event.getEntity();
        class_1799 armor = EquipmentHandler.findOrEmpty((class_1792)ExtraBotanyItems.coreOfTheVoid, (class_1309)owner);
        if (armor.method_7960()) {
            return;
        }
        Relic relic = XplatAbstractions.INSTANCE.findRelic(armor);
        if (relic == null || !(owner instanceof class_1657) || !relic.isRightPlayer(player = (class_1657)owner) || CoreOfTheVoidItem.shouldBackFire(armor, (class_1309)player)) {
            return;
        }
        if (event.getSource().method_48789(class_8103.field_42247)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEventWrapper
    public static void onLivingDamage(LivingDamageEventWrapper event) {
        class_1657 player;
        class_1309 owner = event.getEntity();
        class_1799 armor = EquipmentHandler.findOrEmpty((class_1792)ExtraBotanyItems.coreOfTheVoid, (class_1309)owner);
        if (armor.method_7960()) {
            return;
        }
        Relic relic = XplatAbstractions.INSTANCE.findRelic(armor);
        if (relic == null || !(owner instanceof class_1657) || !relic.isRightPlayer(player = (class_1657)owner) || CoreOfTheVoidItem.shouldBackFire(armor, (class_1309)player)) {
            return;
        }
        if (event.getSource().method_48789(class_8103.field_42247)) {
            event.setCanceled(true);
        }
    }

    protected void tryRemoveHarmfulPotion(class_1799 stack, class_1309 entity) {
        List<class_1293> effects = entity.method_6026().stream().filter(effect -> effect.method_5579().method_18792() == class_4081.field_18272).toList();
        if (!effects.isEmpty() && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (ManaItemHandler.instance().requestManaExactForTool(stack, player, CoreOfTheVoidItem.getCureCost(), true)) {
                effects.forEach(e -> entity.method_6016(e.method_5579()));
            }
        }
    }

    @SubscribeEventWrapper
    public static void onEffectAdd(MobEffectEventWrapper.Applicable event) {
        class_1657 player;
        Relic relic;
        class_1309 owner = event.getEntity();
        class_1799 armor = EquipmentHandler.findOrEmpty((class_1792)ExtraBotanyItems.coreOfTheVoid, (class_1309)owner);
        if (!armor.method_7960() && event.getEffectInstance().method_5579().method_18792() == class_4081.field_18272 && (relic = XplatAbstractions.INSTANCE.findRelic(armor)) != null && owner instanceof class_1657 && relic.isRightPlayer(player = (class_1657)owner) && ManaItemHandler.instance().requestManaExact(armor, player, CoreOfTheVoidItem.getCureCost(), true)) {
            event.setResult(EventWrapper.Result.DENY);
        }
    }

    public static class Renderer
    implements AccessoryRenderer {
        public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            String variantID = CoreOfTheVoidItem.getVariant(stack);
            if (!ExtraBotanyAPI.instance().getCOVVariants().containsKey(variantID)) {
                return;
            }
            CoreOfTheVoidVariant variant = ExtraBotanyAPI.instance().getCOVVariants().get(variantID);
            variant.render(bipedModel, stack, living, ms, buffers, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

