/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.telemetry;

import com.google.gson.JsonObject;
import io.github.lounode.eventwrapper.event.server.ServerStartedEventWrapper;
import io.github.lounode.eventwrapper.event.server.ServerStoppingEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.common.entity.gaia.Gaia;
import io.github.lounode.extrabotany.common.entity.gaia.GaiaIII;
import io.github.lounode.extrabotany.common.telemetry.Metrics;
import io.github.lounode.extrabotany.common.telemetry.MetricsNew;
import io.github.lounode.extrabotany.common.telemetry.TelemetryProperty;
import io.github.lounode.extrabotany.common.telemetry.TelemetryPropertyMap;
import io.github.lounode.extrabotany.common.telemetry.charts.SimplePie;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.UUID;
import net.minecraft.class_1267;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.server.MinecraftServer;

@EventBusSubscriberWrapper
public class ExtraBotanyTelemetry {
    private static ExtraBotanyTelemetry INSTANCE;
    private final int serviceId = 25178;
    private Metrics metrics;
    private final TelemetryPropertyMap deviceSessionProperties;
    private MetricsNew metricsNew;

    public static ExtraBotanyTelemetry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExtraBotanyTelemetry();
        }
        return INSTANCE;
    }

    private ExtraBotanyTelemetry() {
        TelemetryPropertyMap.Builder builder = TelemetryPropertyMap.builder();
        builder.put(TelemetryProperty.GAME_VERSION, class_155.method_16673().method_48018());
        builder.put(TelemetryProperty.OS_NAME, class_156.method_668().method_38649());
        builder.put(TelemetryProperty.OS_ARCH, System.getProperty("os.arch"));
        builder.put(TelemetryProperty.OS_VERSION, System.getProperty("os.version"));
        builder.put(TelemetryProperty.JAVA_VERSION, System.getProperty("java.version"));
        builder.put(TelemetryProperty.CORE_COUNT, Runtime.getRuntime().availableProcessors());
        builder.put(TelemetryProperty.MOD_LOADER, EXplatAbstractions.INSTANCE.getModLoader());
        builder.put(TelemetryProperty.MOD_SERVICE_ID, 25178);
        builder.put(TelemetryProperty.MOD_VERSION, EXplatAbstractions.INSTANCE.getExtraBotanyVersion());
        this.deviceSessionProperties = builder.build();
    }

    @SubscribeEventWrapper
    public static void onServerStarted(ServerStartedEventWrapper event) {
        MinecraftServer server = event.getServer();
        boolean enableTelemetry = ExtraBotanyConfig.common().enableTelemetry();
        if (!enableTelemetry) {
            return;
        }
        String telemetryUUID = ExtraBotanyConfig.common().telemetryUUID();
        ExtraBotanyTelemetry.getInstance().metrics = new Metrics("sponge", telemetryUUID, ExtraBotanyTelemetry.getInstance().serviceId, ExtraBotanyTelemetry.appendPlatformData(server), ExtraBotanyTelemetry.appendServiceData(), server);
        ExtraBotanyTelemetry.getInstance().metrics.addCustomChart(new SimplePie("modLoader", () -> EXplatAbstractions.INSTANCE.isForge() ? "forge" : "fabric"));
        ExtraBotanyTelemetry.getInstance().metrics.addCustomChart(new SimplePie("serverType", () -> server.method_3816() ? TelemetryProperty.ServerType.OTHER.method_15434() : TelemetryProperty.ServerType.LOCAL.method_15434()));
        MetricsNew metricsNew = ExtraBotanyTelemetry.getInstance().metricsNew;
        if (metricsNew != null) {
            metricsNew.shutdown();
            ExtraBotanyTelemetry.getInstance().metricsNew = null;
        }
        ExtraBotanyTelemetry.getInstance().metricsNew = new MetricsNew(ExtraBotanyTelemetry.getInstance().deviceSessionProperties, MetricsNew.getServerUUID(server, UUID.fromString(telemetryUUID)), server);
        ExtraBotanyTelemetry.getInstance().metricsNew.start();
    }

    @SubscribeEventWrapper
    public static void onServerStopping(ServerStoppingEventWrapper event) {
        MetricsNew metricsNew = ExtraBotanyTelemetry.getInstance().metricsNew;
        if (metricsNew != null) {
            metricsNew.shutdown();
            ExtraBotanyTelemetry.getInstance().metricsNew = null;
        }
    }

    private static JsonObject appendPlatformData(MinecraftServer server) {
        JsonObject builder = new JsonObject();
        builder.addProperty("onlineMode", (Number)(server.method_3828() ? 1 : 0));
        builder.addProperty("minecraftVersion", server.method_3827());
        builder.addProperty("javaVersion", System.getProperty("java.version"));
        builder.addProperty("osName", System.getProperty("os.name"));
        builder.addProperty("osArch", System.getProperty("os.arch"));
        builder.addProperty("osVersion", System.getProperty("os.version"));
        builder.addProperty("coreCount", (Number)Runtime.getRuntime().availableProcessors());
        return builder;
    }

    private static JsonObject appendServiceData() {
        JsonObject builder = new JsonObject();
        builder.addProperty("pluginVersion", EXplatAbstractions.INSTANCE.getExtraBotanyVersion());
        return builder;
    }

    public static class Event {
        public static void onGaiaBattleFinish(Gaia gaia) {
            if (((Object)((Object)gaia)).getClass() != GaiaIII.class) {
                return;
            }
            String status = gaia.method_6032() <= 0.0f ? "success" : "failed";
            double health = gaia.method_6032();
            int playerCount = gaia.getPlayerCount();
            class_1267 difficulty = gaia.method_37908().method_8407();
            int durationTicks = gaia.field_6012;
            if (playerCount < 1 || playerCount > 20) {
                return;
            }
            if (difficulty == class_1267.field_5801) {
                return;
            }
            if (durationTicks < 200) {
                return;
            }
            JsonObject data = new JsonObject();
            data.addProperty("status", status);
            data.addProperty("healthRemain", (Number)health);
            data.addProperty("playerCount", (Number)playerCount);
            data.addProperty("difficulty", difficulty.method_5460());
            data.addProperty("duration", (Number)durationTicks);
        }
    }
}

