/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.telemetry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lounode.extrabotany.common.telemetry.charts.Chart;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Metrics");
    public static final String METRICS_VERSION = "3.1.1-SNAPSHOT";
    private static final String REPORT_URL = "https://bStats.org/api/v2/data/%s";
    private final String platform;
    private final String serverUuid;
    private final int serviceId;
    private final JsonObject platformData;
    private final JsonObject appendServiceDataConsumer;
    private final Set<Chart> customCharts = new HashSet<Chart>();
    private final MinecraftServer server;

    public Metrics(String platform, String serverUuid, int serviceId, JsonObject appendPlatformDataConsumer, JsonObject appendServiceDataConsumer, MinecraftServer server) {
        this.platform = platform;
        this.serverUuid = serverUuid;
        this.serviceId = serviceId;
        this.platformData = appendPlatformDataConsumer;
        this.appendServiceDataConsumer = appendServiceDataConsumer;
        this.server = server;
        this.startSubmitting();
    }

    public void addCustomChart(Chart chart) {
        this.customCharts.add(chart);
    }

    private void startSubmitting() {
        Timer timer = new Timer(true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Metrics.this.submitData();
            }
        }, 300000L, 1800000L);
    }

    private void submitData() {
        block3: {
            JsonObject baseJsonBuilder = this.platformData.deepCopy();
            JsonObject serviceJsonBuilder = this.appendServiceDataConsumer.deepCopy();
            JsonArray chartData = new JsonArray();
            for (Chart chart : this.customCharts) {
                JsonObject chartJson = chart.getRequestJsonObject();
                if (chartJson == null) continue;
                chartData.add((JsonElement)chart.getRequestJsonObject());
            }
            serviceJsonBuilder.addProperty("id", (Number)this.serviceId);
            serviceJsonBuilder.add("customCharts", (JsonElement)chartData);
            baseJsonBuilder.add("service", (JsonElement)serviceJsonBuilder);
            baseJsonBuilder.addProperty("serverUUID", this.serverUuid);
            baseJsonBuilder.addProperty("metricsVersion", METRICS_VERSION);
            baseJsonBuilder.addProperty("playerAmount", (Number)this.server.method_3788());
            JsonObject data = baseJsonBuilder;
            try {
                this.sendData(data);
            }
            catch (Exception e) {
                if (!Metrics.debug()) break block3;
                LOGGER.error("Could not submit bStats metrics data", (Throwable)e);
            }
        }
    }

    private void sendData(JsonObject data) throws Exception {
        if (Metrics.debug()) {
            LOGGER.info("Sent bStats metrics data: {}", (Object)data.toString());
        }
        String url = String.format(REPORT_URL, this.platform);
        HttpsURLConnection connection = (HttpsURLConnection)new URL(url).openConnection();
        byte[] compressedData = Metrics.compress(data.toString());
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Connection", "close");
        connection.addRequestProperty("Content-Encoding", "gzip");
        connection.addRequestProperty("Content-Length", String.valueOf(compressedData.length));
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "Metrics-Service/1");
        connection.setDoOutput(true);
        try (DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());){
            outputStream.write(compressedData);
        }
        StringBuilder builder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line);
            }
        }
        if (Metrics.debug()) {
            LOGGER.info("Sent data to bStats and received response: {}", (Object)builder);
        }
    }

    private static byte[] compress(String str) throws IOException {
        if (str == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(outputStream);){
            gzip.write(str.getBytes(StandardCharsets.UTF_8));
        }
        return outputStream.toByteArray();
    }

    private static boolean debug() {
        return System.getProperty("metrics_debug") != null;
    }
}

