/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.telemetry;

import com.google.gson.JsonObject;
import io.github.lounode.extrabotany.common.telemetry.TelemetryProperty;
import io.github.lounode.extrabotany.common.telemetry.TelemetryPropertyMap;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsNew {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"Metrics");
    protected static final String LOCAL_URL = "http://localhost:8080/api/data";
    protected static final String UPLOAD_URL = "https://lounode.top/api/data";
    protected final TelemetryPropertyMap deviceSessionProperties;
    protected final UUID serverUUID;
    private MinecraftServer server;
    private static final ExecutorService METRICS_EXECUTOR = Executors.newCachedThreadPool(r -> {
        Thread t = new Thread(r, "Metrics-Sender");
        t.setDaemon(true);
        return t;
    });
    private final Timer timer;
    protected static final long INITIAL_COOLDOWN = 300000L;
    protected static final long DEFAULT_COOLDOWN = 1800000L;
    protected boolean enable;

    public MetricsNew(TelemetryPropertyMap deviceSessionProperties, UUID serverUUID, MinecraftServer server) {
        this.deviceSessionProperties = deviceSessionProperties;
        this.serverUUID = serverUUID;
        this.server = server;
        this.timer = new Timer(true);
    }

    public void start() {
        if (this.enable) {
            return;
        }
        this.enable = true;
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                MetricsNew.this.submitData();
            }
        }, this.getInitialCooldown(), this.getDefaultCooldown());
    }

    public void shutdown() {
        this.enable = false;
        this.timer.cancel();
    }

    private void submitData() {
        if (!this.enable) {
            return;
        }
        TelemetryPropertyMap.Builder data = TelemetryPropertyMap.builder().putAll(this.deviceSessionProperties);
        this.appendServerData(data, this.getServer());
        METRICS_EXECUTOR.execute(() -> {
            block2: {
                try {
                    this.request(data.build());
                }
                catch (Exception e) {
                    if (!MetricsNew.debug()) break block2;
                    LOGGER.error("Could not submit metrics data", (Throwable)e);
                }
            }
        });
    }

    private void request(TelemetryPropertyMap map) throws Exception {
        JsonObject json = map.toJson();
        if (MetricsNew.debug()) {
            LOGGER.info("Send api with data {}", (Object)json);
        }
        String url = this.getUploadUrl();
        HttpURLConnection connection = MetricsNew.debug() ? (HttpURLConnection)new URL(url).openConnection() : (HttpsURLConnection)new URL(url).openConnection();
        byte[] compressedData = MetricsNew.compress(json.toString());
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Connection", "close");
        connection.addRequestProperty("Content-Encoding", "gzip");
        connection.addRequestProperty("Content-Length", String.valueOf(compressedData.length));
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "Metrics-Service/1");
        connection.setDoOutput(true);
        try (DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());){
            outputStream.write(compressedData);
        }
        StringBuilder builder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line);
            }
        }
        if (MetricsNew.debug()) {
            LOGGER.info("Sent data to api and received response: {}", (Object)builder);
        }
    }

    private void appendServerData(TelemetryPropertyMap.Builder builder, MinecraftServer server) {
        builder.put(TelemetryProperty.ONLINE_MODE, server.method_3828());
        builder.put(TelemetryProperty.PLAYER_AMOUNT, server.method_3788());
        builder.put(TelemetryProperty.SERVER_TYPE, server.method_3816() ? TelemetryProperty.ServerType.OTHER : TelemetryProperty.ServerType.LOCAL);
        builder.put(TelemetryProperty.SERVER_UUID, this.serverUUID);
    }

    protected long getInitialCooldown() {
        return MetricsNew.debug() ? 10000L : 300000L;
    }

    protected long getDefaultCooldown() {
        return 1800000L;
    }

    protected MinecraftServer getServer() {
        return this.server;
    }

    protected String getUploadUrl() {
        return MetricsNew.debug() ? LOCAL_URL : UPLOAD_URL;
    }

    public static UUID getServerUUID(MinecraftServer server, UUID uniqueID) {
        long seed = server.method_27728().method_28057().method_28028();
        String combinedInput = seed + "|" + String.valueOf(uniqueID);
        return UUID.nameUUIDFromBytes(combinedInput.getBytes(StandardCharsets.UTF_8));
    }

    private static byte[] compress(String str) throws IOException {
        if (str == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(outputStream);){
            gzip.write(str.getBytes(StandardCharsets.UTF_8));
        }
        return outputStream.toByteArray();
    }

    private static boolean debug() {
        return System.getProperty("metrics_debug") != null;
    }
}

