/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.telemetry;

import com.mojang.authlib.minecraft.TelemetryPropertyContainer;
import com.mojang.serialization.Codec;
import io.github.lounode.extrabotany.common.telemetry.TelemetryPropertyMap;
import io.github.lounode.extrabotany.common.telemetry.events.GaiaBattleResult;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_3542;
import net.minecraft.class_4844;

public record TelemetryProperty<T>(String id, String exportKey, Codec<T> codec, Exporter<T> exporter) {
    public static final TelemetryProperty<String> GAME_VERSION = TelemetryProperty.string("game_version", "minecraftVersion");
    public static final TelemetryProperty<EXplatAbstractions.ModLoaderType> MOD_LOADER = TelemetryProperty.create("mod_loader", "modLoader", EXplatAbstractions.ModLoaderType.CODEC, (container, key, type) -> container.addProperty(key, type.method_15434()));
    public static final TelemetryProperty<String> OS_NAME = TelemetryProperty.string("operating_system", "osName");
    public static final TelemetryProperty<String> OS_ARCH = TelemetryProperty.string("os_arch", "osArch");
    public static final TelemetryProperty<String> OS_VERSION = TelemetryProperty.string("os_version", "osVersion");
    public static final TelemetryProperty<Integer> CORE_COUNT = TelemetryProperty.integer("core_count", "coreCount");
    public static final TelemetryProperty<String> JAVA_VERSION = TelemetryProperty.string("java_version", "javaVersion");
    public static final TelemetryProperty<UUID> SERVER_UUID = TelemetryProperty.uuid("server_uuid", "serverUUID");
    public static final TelemetryProperty<ServerType> SERVER_TYPE = TelemetryProperty.create("server_type", "serverType", ServerType.CODEC, (container, key, type) -> container.addProperty(key, type.method_15434()));
    public static final TelemetryProperty<Boolean> ONLINE_MODE = TelemetryProperty.bool("online_mode", "onlineMode");
    public static final TelemetryProperty<Integer> PLAYER_AMOUNT = TelemetryProperty.integer("player_amount", "playerAmount");
    public static final TelemetryProperty<Integer> MOD_SERVICE_ID = TelemetryProperty.integer("mod_service_id", "modServiceId");
    public static final TelemetryProperty<String> MOD_VERSION = TelemetryProperty.string("mod_version", "modVersion");
    public static final TelemetryProperty<List<GaiaBattleResult>> GAIA_BATTLE_RESULTS = TelemetryProperty.create("gaia_battle_results", "gaiaBattleResults", GaiaBattleResult.CODEC.listOf().xmap(ArrayList::new, Function.identity()), (container, key, type) -> container.addProperty(key, type.stream().map(GaiaBattleResult::toString).collect(Collectors.joining(";"))));

    public static <T> TelemetryProperty<T> create(String id, String exportKey, Codec<T> codec, Exporter<T> exporter) {
        return new TelemetryProperty<T>(id, exportKey, codec, exporter);
    }

    public static TelemetryProperty<Boolean> bool(String id, String exportKey) {
        return TelemetryProperty.create(id, exportKey, Codec.BOOL, TelemetryPropertyContainer::addProperty);
    }

    public static TelemetryProperty<String> string(String id, String exportKey) {
        return TelemetryProperty.create(id, exportKey, Codec.STRING, TelemetryPropertyContainer::addProperty);
    }

    public static TelemetryProperty<Integer> integer(String id, String exportKey) {
        return TelemetryProperty.create(id, exportKey, Codec.INT, TelemetryPropertyContainer::addProperty);
    }

    public static TelemetryProperty<Long> makeLong(String id, String exportKey) {
        return TelemetryProperty.create(id, exportKey, Codec.LONG, TelemetryPropertyContainer::addProperty);
    }

    public static TelemetryProperty<UUID> uuid(String id, String exportKey) {
        return TelemetryProperty.create(id, exportKey, class_4844.field_41525, (container, key, uuid) -> container.addProperty(key, uuid.toString()));
    }

    public static TelemetryProperty<LongList> longSamples(String id, String exportKey) {
        return TelemetryProperty.create(id, exportKey, Codec.LONG.listOf().xmap(LongArrayList::new, Function.identity()), (p_261674_, p_262049_, p_262118_) -> p_261674_.addProperty(p_262049_, p_262118_.longStream().mapToObj(String::valueOf).collect(Collectors.joining(";"))));
    }

    public void export(TelemetryPropertyMap propertyMap, TelemetryPropertyContainer container) {
        Object t = propertyMap.get(this);
        if (t != null) {
            this.exporter.apply(container, this.exportKey, t);
        } else {
            container.addNullProperty(this.exportKey);
        }
    }

    public static interface Exporter<T> {
        public void apply(TelemetryPropertyContainer var1, String var2, T var3);
    }

    public static enum ServerType implements class_3542
    {
        REALM("realm"),
        LOCAL("local"),
        OTHER("server");

        public static final Codec<ServerType> CODEC;
        private final String key;

        private ServerType(String key) {
            this.key = key;
        }

        public String method_15434() {
            return this.key;
        }

        static {
            CODEC = class_3542.method_28140(ServerType::values);
        }
    }

    public static enum GameMode implements class_3542
    {
        SURVIVAL("survival", 0),
        CREATIVE("creative", 1),
        ADVENTURE("adventure", 2),
        SPECTATOR("spectator", 6),
        HARDCORE("hardcore", 99);

        public static final Codec<GameMode> CODEC;
        private final String key;
        private final int id;

        private GameMode(String key, int id) {
            this.key = key;
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public String method_15434() {
            return this.key;
        }

        static {
            CODEC = class_3542.method_28140(GameMode::values);
        }
    }
}

