/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.util;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.client.book.BookContentLoader;
import vazkii.patchouli.client.book.BookContentResourceDirectLoader;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.template.BookTemplate;
import vazkii.patchouli.common.book.Book;

public class PatchouliUtil {
    public static PatchouliUtil INSTANCE;
    private final Map<class_2960, Supplier<BookTemplate>> templatesPool = new HashMap<class_2960, Supplier<BookTemplate>>();

    private PatchouliUtil() {
    }

    public static void onPatchouliReload(Map<class_2960, Book> books) {
        if (INSTANCE == null) {
            INSTANCE = new PatchouliUtil();
        }
        PatchouliUtil.INSTANCE.templatesPool.clear();
        for (Book book : books.values()) {
            INSTANCE.load(book, "templates", PatchouliUtil::loadTemplate, PatchouliUtil.INSTANCE.templatesPool);
        }
    }

    @Nullable
    public Supplier<BookTemplate> getTemplate(class_2960 id) {
        return this.templatesPool.get(id);
    }

    private static Supplier<BookTemplate> loadTemplate(Book book, BookContentLoader loader, class_2960 key, class_2960 res) {
        JsonElement json = PatchouliUtil.loadLocalizedJson(book, loader, res).json();
        Supplier<BookTemplate> supplier = () -> (BookTemplate)ClientBookRegistry.INSTANCE.gson.fromJson(json, BookTemplate.class);
        BookTemplate template = supplier.get();
        if (template == null) {
            throw new IllegalArgumentException(String.valueOf(res) + " could not be instantiated by the supplier.");
        }
        return supplier;
    }

    private static BookContentLoader.LoadResult loadLocalizedJson(Book book, BookContentLoader loader, class_2960 file) {
        class_2960 localizedFile = class_2960.method_43902((String)file.method_12836(), (String)file.method_12832().replaceAll("en_us", ClientBookRegistry.INSTANCE.currentLang));
        BookContentLoader.LoadResult input = loader.loadJson(book, localizedFile);
        if (input == null && (input = loader.loadJson(book, file)) == null) {
            throw new IllegalArgumentException(String.valueOf(file) + " does not exist.");
        }
        return input;
    }

    private <T> void load(Book book, String thing, LoadFunc<T> loader, Map<class_2960, T> builder) {
        BookContentResourceDirectLoader contentLoader = BookContentResourceDirectLoader.INSTANCE;
        ArrayList foundIds = new ArrayList();
        contentLoader.findFiles(book, thing, foundIds);
        for (class_2960 id : foundIds) {
            String filePath = String.format("%s/%s/%s/%s/%s.json", "patchouli_books", book.id.method_12832(), "en_us", thing, id.method_12832());
            T value = loader.load(book, (BookContentLoader)contentLoader, id, class_2960.method_43902((String)id.method_12836(), (String)filePath));
            if (value == null) continue;
            builder.put(id, value);
        }
    }

    private static interface LoadFunc<T> {
        @Nullable
        public T load(Book var1, BookContentLoader var2, class_2960 var3, class_2960 var4);
    }
}

