/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data.loot;

import com.google.gson.JsonElement;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.class_104;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_173;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_201;
import net.minecraft.class_2035;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_212;
import net.minecraft.class_223;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2362;
import net.minecraft.class_2405;
import net.minecraft.class_2482;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_3837;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_52;
import net.minecraft.class_5270;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5646;
import net.minecraft.class_5651;
import net.minecraft.class_5658;
import net.minecraft.class_7403;
import net.minecraft.class_77;
import net.minecraft.class_7784;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_85;
import org.jetbrains.annotations.NotNull;

public class BlockLootProvider
implements class_2405 {
    private static final class_5341.class_210 SILK_TOUCH = class_223.method_945((class_2073.class_2074)class_2073.class_2074.method_8973().method_8978(new class_2035(class_1893.field_9099, class_2096.class_2100.method_9053((int)1))));
    private static final Function<class_2248, class_52.class_53> SKIP = b -> {
        throw new RuntimeException("shouldn't be executed");
    };
    private final class_7784.class_7489 pathProvider;
    private final Map<class_2248, Function<class_2248, class_52.class_53>> functionTable = new HashMap<class_2248, Function<class_2248, class_52.class_53>>();

    public BlockLootProvider(class_7784 packOutput) {
        this.pathProvider = packOutput.method_45973(class_7784.class_7490.field_39367, "loot_tables/blocks");
        for (class_2248 b2 : class_7923.field_41175) {
            class_2960 id = class_7923.field_41175.method_10221((Object)b2);
            if (!"extrabotany".equals(id.method_12836())) continue;
            if (b2 instanceof class_2482) {
                this.functionTable.put(b2, BlockLootProvider::genSlab);
                continue;
            }
            if (!(b2 instanceof class_2362)) continue;
            class_2362 flowerPot = (class_2362)b2;
            this.functionTable.put(b2, block -> BlockLootProvider.createPotAndPlantItemTable((class_1935)flowerPot.method_16231()));
        }
        this.functionTable.put(ExtrabotanyFlowerBlocks.woodienia, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.woodieniaFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.reikarlily, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.reikarlilyFloating, b -> BlockLootProvider.genCopyNbt(b, "cooldown"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.bellflower, b -> BlockLootProvider.genCopyNbt(b, "passiveDecayTicks"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.bellflowerFloating, b -> BlockLootProvider.genCopyNbt(b, "passiveDecayTicks"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.resoncund, b -> BlockLootProvider.genCopyNbt(b, "soundHeard"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.resoncundFloating, b -> BlockLootProvider.genCopyNbt(b, "soundHeard"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.sunshineLily, b -> BlockLootProvider.genCopyNbt(b, "passiveDecayTicks"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.sunshineLilyFloating, b -> BlockLootProvider.genCopyNbt(b, "passiveDecayTicks"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.moonlightLily, b -> BlockLootProvider.genCopyNbt(b, "passiveDecayTicks"));
        this.functionTable.put(ExtrabotanyFlowerBlocks.moonlightLilyFloating, b -> BlockLootProvider.genCopyNbt(b, "passiveDecayTicks"));
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        HashMap<class_2960, class_52.class_53> tables = new HashMap<class_2960, class_52.class_53>();
        for (class_2248 b : class_7923.field_41175) {
            Function<class_2248, class_52.class_53> func;
            class_2960 id = class_7923.field_41175.method_10221((Object)b);
            if (!"extrabotany".equals(id.method_12836()) || (func = this.functionTable.getOrDefault(b, BlockLootProvider::genRegular)) == SKIP) continue;
            tables.put(id, func.apply(b));
        }
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>();
        for (Map.Entry e : tables.entrySet()) {
            Path path = this.pathProvider.method_44107((class_2960)e.getKey());
            output.add(class_2405.method_10320((class_7403)cache, (JsonElement)class_5270.method_27862().create().toJsonTree((Object)((class_52.class_53)e.getValue()).method_334(class_173.field_1172).method_338()), (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    protected static class_52.class_53 genCopyNbt(class_2248 b, String ... tags) {
        class_85.class_86 entry = class_77.method_411((class_1935)b);
        class_3837.class_3838 func = class_3837.method_16848((class_5651)class_5646.field_27914);
        for (String tag : tags) {
            func = func.method_16856(tag, "BlockEntityTag." + tag);
        }
        class_55.class_56 pool = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry).method_356(class_201.method_871()).method_353((class_117.class_118)func);
        return class_52.method_324().method_336(pool);
    }

    protected static class_52.class_53 genRegular(class_2248 b) {
        class_85.class_86 entry = class_77.method_411((class_1935)b);
        class_55.class_56 pool = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry).method_356(class_201.method_871());
        return class_52.method_324().method_336(pool);
    }

    protected static class_52.class_53 genSlab(class_2248 b) {
        class_85.class_86 entry = class_77.method_411((class_1935)b).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)2.0f)).method_524((class_5341.class_210)class_212.method_900((class_2248)b).method_22584(class_4559.class_4560.method_22523().method_22525((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682)))).method_438((class_117.class_118)class_104.method_478());
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry));
    }

    protected static class_52.class_53 createPotAndPlantItemTable(class_1935 plant) {
        class_55.class_56 potPool = class_55.method_347().method_351((class_79.class_80)class_77.method_411((class_1935)class_2246.field_10495)).method_352((class_5658)class_44.method_32448((float)1.0f)).method_356(class_201.method_871());
        class_55.class_56 plantPool = class_55.method_347().method_351((class_79.class_80)class_77.method_411((class_1935)plant)).method_352((class_5658)class_44.method_32448((float)1.0f)).method_356(class_201.method_871());
        return class_52.method_324().method_336(potPool).method_336(plantPool);
    }

    @NotNull
    public String method_10321() {
        return "ExtraBotany block loot tables";
    }
}

