/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data.loot;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_190;
import net.minecraft.class_1935;
import net.minecraft.class_2022;
import net.minecraft.class_2040;
import net.minecraft.class_2048;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_7106;
import net.minecraft.class_7376;
import net.minecraft.class_7699;
import net.minecraft.class_77;
import net.minecraft.class_7791;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_83;

public abstract class EntityLootSubProviderFix
implements class_7791 {
    protected static final class_2048.class_2049 ENTITY_ON_FIRE = class_2048.class_2049.method_8916().method_8919(class_2040.class_2041.method_8897().method_8898(Boolean.valueOf(true)).method_8899());
    private static final Set<class_1299<?>> SPECIAL_LOOT_TABLE_TYPES = ImmutableSet.of((Object)class_1299.field_6097, (Object)class_1299.field_6131, (Object)class_1299.field_6147, (Object)class_1299.field_6047, (Object)class_1299.field_6077);
    private final class_7699 allowed;
    private final class_7699 required;
    private final Map<class_1299<?>, Map<class_2960, class_52.class_53>> map = Maps.newHashMap();

    protected EntityLootSubProviderFix(class_7699 enabledFeatures) {
        this(enabledFeatures, enabledFeatures);
    }

    protected EntityLootSubProviderFix(class_7699 allowed, class_7699 required) {
        this.allowed = allowed;
        this.required = required;
    }

    protected static class_52.class_53 createSheepTable(class_1935 woolItem) {
        return class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)woolItem))).method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_83.method_428((class_2960)class_1299.field_6115.method_16351())));
    }

    protected abstract Stream<class_1299<?>> getKnownEntityTypes();

    public abstract void generate();

    public void method_10399(BiConsumer<class_2960, class_52.class_53> output) {
        this.generate();
        HashSet set = Sets.newHashSet();
        this.getKnownEntityTypes().forEach(entitytype -> {
            class_2960 key = class_7923.field_41177.method_10221(entitytype);
            if (entitytype.method_45382(this.allowed)) {
                if (EntityLootSubProviderFix.canHaveLootTable(entitytype)) {
                    Map<class_2960, class_52.class_53> map = this.map.remove(entitytype);
                    class_2960 resourcelocation = entitytype.method_16351();
                    if (!(resourcelocation.equals((Object)class_39.field_844) || !entitytype.method_45382(this.required) || map != null && map.containsKey(resourcelocation))) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Missing loottable '%s' for '%s'", resourcelocation, key));
                    }
                    if (map != null) {
                        map.forEach((p_250376_, p_250972_) -> {
                            if (!set.add(p_250376_)) {
                                throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate loottable '%s' for '%s'", p_250376_, key));
                            }
                            output.accept((class_2960)p_250376_, (class_52.class_53)p_250972_);
                        });
                    }
                } else {
                    Map<class_2960, class_52.class_53> map1 = this.map.remove(entitytype);
                    if (map1 != null) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Weird loottables '%s' for '%s', not a LivingEntity so should not have loot", map1.keySet().stream().map(class_2960::toString).collect(Collectors.joining(",")), key));
                    }
                }
            }
        });
        if (!this.map.isEmpty()) {
            throw new IllegalStateException("Created loot tables for entities not supported by datapack: " + String.valueOf(this.map.keySet()));
        }
    }

    private static boolean canHaveLootTable(class_1299<?> entityType) {
        return SPECIAL_LOOT_TABLE_TYPES.contains(entityType) || entityType.method_5891() != class_1311.field_17715;
    }

    protected class_5341.class_210 killedByFrog() {
        return class_190.method_837((class_2022.class_2023)class_2022.class_2023.method_8855().method_35131(class_2048.class_2049.method_8916().method_8921(class_1299.field_37419)));
    }

    protected class_5341.class_210 killedByFrogVariant(class_7106 frogVariant) {
        return class_190.method_837((class_2022.class_2023)class_2022.class_2023.method_8855().method_35131(class_2048.class_2049.method_8916().method_8921(class_1299.field_37419).method_43094(class_7376.method_43096((class_7106)frogVariant))));
    }

    protected void add(class_1299<?> entityType, class_52.class_53 builder) {
        this.add(entityType, entityType.method_16351(), builder);
    }

    protected void add(class_1299<?> entityType, class_2960 lootTableLocation, class_52.class_53 builder) {
        this.map.computeIfAbsent(entityType, p_251466_ -> new HashMap()).put(lootTableLocation, builder);
    }
}

