/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data.patchouli;

import com.demonwav.mcdev.annotations.Translatable;
import io.github.lounode.extrabotany.common.lib.RegistryHelper;
import io.github.lounode.extrabotany.data.patchouli.PatchouliEntry;
import io.github.lounode.extrabotany.data.patchouli.page.AbstractPage;
import io.github.lounode.extrabotany.data.patchouli.page.IPatchouliPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class PatchouliBuilder {
    private final class_2960 category;
    private String name;
    private class_1792 icon;
    private int sortNum;
    private class_2960 advancement;
    private final List<IPatchouliPage> pages = new ArrayList<IPatchouliPage>();
    private final Map<class_2960, Integer> extraRecipeMappings = new HashMap<class_2960, Integer>();
    private boolean priority;
    private boolean secret;
    private boolean read;
    @Nullable
    private Integer color;

    public PatchouliBuilder(class_2960 category, @Translatable String name, class_1935 icon, int sortNum) {
        this.category = category;
        this.name = name;
        this.icon = icon.method_8389();
        this.sortNum = sortNum;
    }

    public static PatchouliBuilder entry(class_2960 category) {
        return new PatchouliBuilder(category, "null", (class_1935)class_1802.field_8407, 0);
    }

    public PatchouliBuilder withName(@Translatable String name) {
        this.name = name;
        return this;
    }

    public PatchouliBuilder withIcon(class_1935 icon) {
        this.icon = icon.method_8389();
        return this;
    }

    public PatchouliBuilder withSortNum(int sortNum) {
        this.sortNum = sortNum;
        return this;
    }

    public PatchouliBuilder withAdvancement(class_161 advancement) {
        this.advancement = advancement.method_688();
        return this;
    }

    public PatchouliBuilder withAdvancement(class_2960 advancement) {
        this.advancement = advancement;
        return this;
    }

    public PatchouliBuilder pages(AbstractPage<?> ... page) {
        this.pages.addAll(List.of(page));
        return this;
    }

    public void save(Consumer<PatchouliEntry> consumer, class_2960 id) {
        consumer.accept(new PatchouliEntry(this.category, this.name, this.icon, this.pages, class_2960.method_43902((String)this.category.method_12832(), (String)id.method_12832()), this.sortNum, this.advancement, this.extraRecipeMappings, this.priority, this.secret, this.read, this.color));
    }

    public PatchouliBuilder extraRecipeMapping(class_1792 item, int pageNum) {
        if (item == class_1802.field_8162) {
            return this;
        }
        class_2960 location = RegistryHelper.getRegistryName(item);
        this.extraRecipeMappings.put(location, pageNum);
        return this;
    }

    public PatchouliBuilder extraRecipeMapping(class_2248 block, int pageNum) {
        if (block == class_2246.field_10124) {
            return this;
        }
        class_2960 location = RegistryHelper.getRegistryName(block);
        this.extraRecipeMappings.put(location, pageNum);
        return this;
    }

    public PatchouliBuilder priority() {
        this.priority = true;
        return this;
    }

    public PatchouliBuilder secret() {
        this.secret = true;
        return this;
    }

    public PatchouliBuilder defaultRead() {
        this.read = true;
        return this;
    }

    public PatchouliBuilder color(int color) {
        this.color = color;
        return this;
    }
}

