/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data.patchouli;

import com.demonwav.mcdev.annotations.Translatable;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import io.github.lounode.extrabotany.data.patchouli.PatchouliEntry;
import io.github.lounode.extrabotany.data.patchouli.page.patchouli.CraftingPage;
import io.github.lounode.extrabotany.data.patchouli.page.patchouli.EmptyPage;
import io.github.lounode.extrabotany.data.patchouli.page.patchouli.MultiBlockPage;
import io.github.lounode.extrabotany.data.patchouli.page.patchouli.SpotlightPage;
import io.github.lounode.extrabotany.data.patchouli.page.patchouli.TextPage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_1935;
import net.minecraft.class_2405;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;

public abstract class PatchouliProvider
implements class_2405 {
    protected class_7784 packOutput;

    public PatchouliProvider(class_7784 packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        HashSet checkDuplicates = Sets.newHashSet();
        ArrayList output = new ArrayList();
        this.buildEntries(entry -> {
            if (!checkDuplicates.add(entry.getID())) {
                throw new IllegalStateException("Duplicate entry " + String.valueOf(entry.getID()));
            }
            output.add(class_2405.method_10320((class_7403)cache, (JsonElement)entry.serializeEntry(), (Path)this.getOutputPath((PatchouliEntry)entry)));
        });
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    protected abstract Path getOutputPath(PatchouliEntry var1);

    protected abstract void buildEntries(Consumer<PatchouliEntry> var1);

    protected EmptyPage empty() {
        return new EmptyPage();
    }

    protected TextPage text(@Translatable String text) {
        return new TextPage(text);
    }

    protected CraftingPage crafting(class_1935 itemLike) {
        return new CraftingPage(itemLike);
    }

    protected CraftingPage crafting(String recipe) {
        return new CraftingPage(recipe);
    }

    protected SpotlightPage spotlight(class_1935 itemLike) {
        return new SpotlightPage(itemLike).linkRecipe(true);
    }

    protected MultiBlockPage multiBlock(@Translatable String name, String[][] pattern) {
        return new MultiBlockPage(name, pattern);
    }

    @NotNull
    public String method_10321() {
        return "Patchouli Provider";
    }
}

