/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data.sound;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lounode.extrabotany.data.sound.SoundDefinition;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SoundDefinitionsProvider
implements class_2405 {
    private static final Logger LOGGER = LogManager.getLogger();
    private final class_7784 output;
    private final String modId;
    private final Map<String, SoundDefinition> sounds = new LinkedHashMap<String, SoundDefinition>();

    protected SoundDefinitionsProvider(class_7784 output, String modId) {
        this.output = output;
        this.modId = modId;
    }

    public abstract void registerSounds();

    public CompletableFuture<?> method_10319(class_7403 cache) {
        this.sounds.clear();
        this.registerSounds();
        this.validate();
        if (!this.sounds.isEmpty()) {
            return this.save(cache, this.output.method_45972(class_7784.class_7490.field_39368).resolve(this.modId).resolve("sounds.json"));
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public String method_10321() {
        return "Sound Definitions";
    }

    protected static SoundDefinition definition() {
        return SoundDefinition.definition();
    }

    protected static SoundDefinition.Sound sound(class_2960 name, SoundDefinition.SoundType type) {
        return SoundDefinition.Sound.sound(name, type);
    }

    protected static SoundDefinition.Sound sound(class_2960 name) {
        return SoundDefinitionsProvider.sound(name, SoundDefinition.SoundType.SOUND);
    }

    protected static SoundDefinition.Sound sound(String name, SoundDefinition.SoundType type) {
        return SoundDefinitionsProvider.sound(class_2960.method_12829((String)name), type);
    }

    protected static SoundDefinition.Sound sound(String name) {
        return SoundDefinitionsProvider.sound(class_2960.method_12829((String)name));
    }

    protected void add(Supplier<class_3414> soundEvent, SoundDefinition definition) {
        this.add(soundEvent.get(), definition);
    }

    protected void add(class_3414 soundEvent, SoundDefinition definition) {
        this.add(soundEvent.method_14833(), definition);
    }

    protected void add(class_2960 soundEvent, SoundDefinition definition) {
        this.addSounds(soundEvent.method_12832(), definition);
    }

    protected void add(String soundEvent, SoundDefinition definition) {
        this.add(class_2960.method_12829((String)soundEvent), definition);
    }

    private void addSounds(String soundEvent, SoundDefinition definition) {
        if (this.sounds.put(soundEvent, definition) != null) {
            throw new IllegalStateException("Sound event '" + this.modId + ":" + soundEvent + "' already exists");
        }
    }

    private void validate() {
        List<String> notValid = this.sounds.entrySet().stream().filter(it -> !this.validate((String)it.getKey(), (SoundDefinition)it.getValue())).map(Map.Entry::getKey).map(it -> this.modId + ":" + it).toList();
        if (!notValid.isEmpty()) {
            throw new IllegalStateException("Found invalid sound events: " + String.valueOf(notValid));
        }
    }

    private boolean validate(String name, SoundDefinition def) {
        return def.soundList().stream().allMatch(it -> this.validate(name, (SoundDefinition.Sound)it));
    }

    private boolean validate(String name, SoundDefinition.Sound sound) {
        switch (sound.type()) {
            case SOUND: {
                return this.validateSound(name, sound.name());
            }
            case EVENT: {
                return this.validateEvent(name, sound.name());
            }
        }
        throw new IllegalArgumentException("The given sound '" + String.valueOf(sound.name()) + "' does not have a valid type: expected either SOUND or EVENT, but found " + String.valueOf((Object)sound.type()));
    }

    private boolean validateSound(String soundName, class_2960 name) {
        return true;
    }

    private boolean validateEvent(String soundName, class_2960 name) {
        boolean valid;
        boolean bl = valid = this.sounds.containsKey(soundName) || class_7923.field_41172.method_10250(name);
        if (!valid) {
            LOGGER.warn("Unable to find event '{}' referenced from '{}'", (Object)name, (Object)soundName);
        }
        return valid;
    }

    private CompletableFuture<?> save(class_7403 cache, Path targetFile) {
        return class_2405.method_10320((class_7403)cache, (JsonElement)this.mapToJson(this.sounds), (Path)targetFile);
    }

    private JsonObject mapToJson(Map<String, SoundDefinition> map) {
        JsonObject obj = new JsonObject();
        map.forEach((k, v) -> obj.add(k, (JsonElement)v.serialize()));
        return obj;
    }
}

