/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.fabric;

import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import io.github.lounode.extrabotany.api.ExtraBotanyAPI;
import io.github.lounode.extrabotany.common.block.flower.generating.BellflowerBlockEntity;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import vazkii.botania.xplat.XplatAbstractions;

public class FabricExtraBotanyConfig {
    private static final Client CLIENT = new Client();
    private static final COMMON COMMON = new COMMON();

    public static void setup() {
        try {
            Files.createDirectory(Paths.get("config", new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            ExtraBotanyAPI.LOGGER.warn("Failed to make config dir", (Throwable)e);
        }
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        ConfigTree common = COMMON.configure(ConfigTree.builder());
        FabricExtraBotanyConfig.setupConfig(common, Paths.get("config", "extrabotany-common.json5"), serializer);
        ExtraBotanyConfig.setCommon(COMMON);
        if (XplatAbstractions.INSTANCE.isPhysicalClient()) {
            ConfigTree client = CLIENT.configure(ConfigTree.builder());
            FabricExtraBotanyConfig.setupConfig(client, Paths.get("config", "extrabotany-client.json5"), serializer);
            ExtraBotanyConfig.setClient(CLIENT);
        }
        ExtraBotanyConfig.resetPatchouliFlags();
    }

    private static void writeDefaultConfig(ConfigTree config, Path path, JanksonValueSerializer serializer) {
        try (BufferedOutputStream s2 = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            FiberSerialization.serialize((ConfigTree)config, (OutputStream)s2, (ValueSerializer)serializer);
        }
        catch (FileAlreadyExistsException s2) {
        }
        catch (IOException e) {
            ExtraBotanyAPI.LOGGER.error("Error writing default config", (Throwable)e);
        }
    }

    private static void setupConfig(ConfigTree config, Path p, JanksonValueSerializer serializer) {
        Closeable s;
        FabricExtraBotanyConfig.writeDefaultConfig(config, p, serializer);
        try {
            s = new BufferedInputStream(Files.newInputStream(p, new OpenOption[0]));
            try {
                FiberSerialization.deserialize((ConfigTree)config, (InputStream)s, (ValueSerializer)serializer);
            }
            finally {
                ((InputStream)s).close();
            }
        }
        catch (ValueDeserializationException | IOException e) {
            ExtraBotanyAPI.LOGGER.error("Error loading config from {}", (Object)p, (Object)e);
        }
        try {
            s = new BufferedOutputStream(Files.newOutputStream(p, StandardOpenOption.TRUNCATE_EXISTING));
            try {
                FiberSerialization.serialize((ConfigTree)config, (OutputStream)s, (ValueSerializer)serializer);
            }
            finally {
                ((OutputStream)s).close();
            }
        }
        catch (IOException e) {
            ExtraBotanyAPI.LOGGER.error("Error writing merged config to {}", (Object)p, (Object)e);
        }
    }

    private static class COMMON
    implements ExtraBotanyConfig.ConfigAccess {
        public final PropertyMirror<Boolean> disableGaiaDisArm = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> enableTelemetry = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<String> telemetryUUID = PropertyMirror.create((ConfigType)ConfigTypes.STRING);
        public final PropertyMirror<String> fakePlayerId = PropertyMirror.create((ConfigType)ConfigTypes.STRING);
        public final PropertyMirror<int[]> woodieniaRange = PropertyMirror.create((ConfigType)ConfigTypes.makeIntArray((ConfigType)ConfigTypes.INTEGER));
        public final PropertyMirror<Integer> woodieniaCooldown = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> woodieniaMaxMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> woodieniaWorkManaCost = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> reikarlilyMaxMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> reikarlilyProduceCooldown = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> reikarlilyProduceMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> reikarlilyPassiveGenerateTime = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> reikarlilyPassiveGenerateMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> reikarlilySpawnLightningCooldown = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> tradeOrchidMaxMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> tradeOrchidManaCost = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> tradeOrchidCooldown = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Double> tradeOrchidDiscountPercentage = PropertyMirror.create((ConfigType)ConfigTypes.DOUBLE);
        public final PropertyMirror<Integer> bellflowerMaxMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Double> bellflowerGenerateModify = PropertyMirror.create((ConfigType)ConfigTypes.DOUBLE);
        public final PropertyMirror<Integer> annoyingflowerMaxMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> annoyingflowerFishingCost = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> annoyingflowerCooldown = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> annoyingflowerFoodBoostMax = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> annoyingflowerFoodBoostTimes = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Double> annoyingflowerFoodBoostCooldownMultiplier = PropertyMirror.create((ConfigType)ConfigTypes.DOUBLE);
        public final PropertyMirror<Integer> stonesiaMaxMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> stonesiaCooldown = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> edelweissMaxMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> edelweissCooldown = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> resoncundMaxMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> resoncundLossPerHeard = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> sunshineLilyMaxMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> sunshineLilyProduceMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> moonlightLilyMaxMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> moonlightLilyProduceMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> twinstarMaxMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> twinstarMaxTemperature = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> twinstarMinTemperature = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> omnivioletMaxMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> tinkleMaxMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> tinkleProduceMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> bloodEnchantressMaxMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> bloodEnchantressProduceMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> serenitianRange = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> mirrowtuniaMaxMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> mirrowtuniaEffectCost = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> necrofleurMaxMana = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> manalinkTransferSpeed = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> enchanterTransformCost = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Integer> enchanterConsumeSpeed = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<List<String>> gaiaSpawnUnCheckList = PropertyMirror.create((ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING));

        private COMMON() {
        }

        public ConfigTree configure(ConfigTreeBuilder builder) {
            builder.fork("server").fork("telemetry").beginValue("enableTelemetry", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("\u6211\u4eec\u4f7f\u7528\u9065\u6d4b\u6570\u636e\u6765\u63d0\u4f9b\u66f4\u597d\u7684\u6e38\u73a9\u4f53\u9a8c\u3002\n\u4ee5\u4e0b\u6570\u636e\u5728\u60a8\u7684\u6e38\u73a9\u8fc7\u7a0b\u4e2d\u5c06\u88ab\u6536\u96c6\uff1a\n\t- \u76d6\u4e9a\u4e09\u901a\u8fc7\u7387\n\t- \u5176\u4ed6...\n\n\u60a8\u53ef\u4ee5\u5728 https://github.com/Lounode/Extrabotany \u4e0a\u627e\u5230\u66f4\u591a\n\u5982\u679c\u60a8\u4e0d\u60f3\u88ab\u6536\u96c6\u8fd9\u4e9b\u6570\u636e\uff0c\u5728\u4e0b\u65b9\u5c06\u914d\u7f6e\u9879\u6539\u4e3a false\n\nWe use telemetry data to provide a better gameplay experience.\nThe following data will be collected during your play session:\n\t- Gaia III completion rate\n\t- etc...\n\nFind more on: https://github.com/Lounode/Extrabotany\nIf you prefer not to participate, set the option below to false.\n").finishValue(arg_0 -> this.enableTelemetry.mirror(arg_0)).beginValue("telemetryUUID", (ConfigType)ConfigTypes.STRING, (Object)UUID.randomUUID().toString()).withComment("\u9065\u6d4b\u6570\u636eUUID\nThe UUID of the telemetry data\n").finishValue(arg_0 -> this.telemetryUUID.mirror(arg_0)).finishBranch().fork("gaia").beginValue("disableGaiaDisarm", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("\u8bbe\u4e3a true \u6765\u7981\u7528\u76d6\u4e9a\u7684\u7f34\u68b0\u6280\u80fd\nSet true to disable Gaia's disarm\n").finishValue(arg_0 -> this.disableGaiaDisArm.mirror(arg_0)).beginValue("gaiaSpawnUnCheckList", (ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING), List.of("minecraft", "botania", "extrabotany")).withComment("\u76d6\u4e9a\u4e09\u751f\u6210\u65f6\u4e0d\u68c0\u67e5\u7684ModID\u6216\u8005\u7269\u54c1\n\u793a\u4f8b\uff1aminecraft, sophisticatedbackpacks:backpack\nItems or ModIDs that gaia ignore to check when spawn\ne.g. minecraft, sophisticatedbackpacks:backpack").finishValue(arg_0 -> this.gaiaSpawnUnCheckList.mirror(arg_0)).finishBranch().fork("fakePlayer").beginValue("fakePlayerId", (ConfigType)ConfigTypes.STRING, (Object)"[Extrabotany]").withComment("\u5047\u73a9\u5bb6ID\uff08\u7528\u4e8e\u6743\u9650\u914d\u7f6e\uff09\nFake Player ID (for permission configuration)\n").finishValue(arg_0 -> this.fakePlayerId.mirror(arg_0)).finishBranch().fork("flower").fork("tradeOrchid").withComment("\u5546\u53cb\u5170\nTrade Orchid").beginValue("maxMana", (ConfigType)ConfigTypes.INTEGER, (Object)10000).withComment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").finishValue(arg_0 -> this.tradeOrchidMaxMana.mirror(arg_0)).beginValue("manaCost", (ConfigType)ConfigTypes.INTEGER, (Object)1000).withComment("\u6bcf\u53ea\u6751\u6c11\u6d88\u8017\u7684\u9b54\u529b\u91cf\nMana cost per villager").finishValue(arg_0 -> this.tradeOrchidManaCost.mirror(arg_0)).beginValue("cooldown", (ConfigType)ConfigTypes.INTEGER, (Object)40).withComment("\u51b7\u5374\u65f6\u95f4(ticks)\nCooldown time in ticks").finishValue(arg_0 -> this.tradeOrchidCooldown.mirror(arg_0)).beginValue("discountPercentage", (ConfigType)ConfigTypes.DOUBLE, (Object)0.5).withComment("\u6298\u6263\u767e\u5206\u6bd4(\u4ec5\u652f\u6301\u7cbe\u786e\u5230\u4e24\u4f4d\u5c0f\u6570)\n(\u4f8b\u5982\uff1a0.85 = \u516b\u4e94\u6298)\nDiscount percentage (max precision: 0.01)\n(e.g., 0.85 = 15% off)").finishValue(arg_0 -> this.tradeOrchidDiscountPercentage.mirror(arg_0)).finishBranch().fork("woodienia").withComment("\u4f10\u6728\u82b1\nWoodienia").beginValue("maxMana", (ConfigType)ConfigTypes.INTEGER, (Object)10000).withComment("\u6700\u5927\u9b54\u529b\nMaximum Mana").finishValue(arg_0 -> this.woodieniaMaxMana.mirror(arg_0)).beginValue("workManaCost", (ConfigType)ConfigTypes.INTEGER, (Object)200).withComment("\u7834\u574f\u539f\u6728\u7684\u9b54\u529b\u6d88\u8017\nCost when break Logs").finishValue(arg_0 -> this.woodieniaWorkManaCost.mirror(arg_0)).beginValue("range", (ConfigType)ConfigTypes.makeIntArray((ConfigType)ConfigTypes.INTEGER), (Object)new int[]{8, 16, 8}).withComment("\u4ee5\u81ea\u8eab\u4e3a\u4e2d\u5fc3\u7684\u5de5\u4f5c\u8303\u56f4\uff08\u00b1X\u8f74\uff0c+Y\u8f74\uff0c\u00b1Z\u8f74\uff09\nWorking range centered on self (\u00b1X axis, +Y axis, \u00b1Z axis)").finishValue(arg_0 -> this.woodieniaRange.mirror(arg_0)).beginValue("cooldown", (ConfigType)ConfigTypes.INTEGER, (Object)10).withComment("\u5de5\u4f5c\u95f4\u9694\nCooldown interval").finishValue(arg_0 -> this.woodieniaCooldown.mirror(arg_0)).finishBranch().fork("reikarlily").withComment("\u96f7\u5361\u5170\nReikarlily").beginValue("maxMana", (ConfigType)ConfigTypes.INTEGER, (Object)12000).withComment("\u6700\u5927\u9b54\u529b\nMaximum Mana").finishValue(arg_0 -> this.reikarlilyMaxMana.mirror(arg_0)).beginValue("produceCooldown", (ConfigType)ConfigTypes.INTEGER, (Object)3600).withComment("\u96f7\u51fb\u540e\u518d\u6b21\u4ea7\u51fa\u9b54\u529b\u7684\u51b7\u5374\u65f6\u95f4\nCooldown time for regenerating mana after a lightning strike").finishValue(arg_0 -> this.reikarlilyProduceCooldown.mirror(arg_0)).beginValue("produceMana", (ConfigType)ConfigTypes.INTEGER, (Object)12000).withComment("\u96f7\u51fb\u751f\u6210\u7684\u9b54\u529b\u91cf\nMana generated per lightning strike").finishValue(arg_0 -> this.reikarlilyProduceMana.mirror(arg_0)).beginValue("passiveGenerateTime", (ConfigType)ConfigTypes.INTEGER, (Object)1500).withComment("\u96f7\u51fb\u540e\u88ab\u52a8\u751f\u6210\u9b54\u529b\u7684\u65f6\u95f4\nPassive mana generation duration after lightning strike").finishValue(arg_0 -> this.reikarlilyPassiveGenerateTime.mirror(arg_0)).beginValue("passiveGenerateMana", (ConfigType)ConfigTypes.INTEGER, (Object)45).withComment("\u96f7\u51fb\u540e\u6bcfTick\u88ab\u52a8\u751f\u6210\u7684\u9b54\u529b\u91cf\nMana generated per passive tick").finishValue(arg_0 -> this.reikarlilyPassiveGenerateMana.mirror(arg_0)).beginValue("spawnLightningCooldown", (ConfigType)ConfigTypes.INTEGER, (Object)3600).withComment("\u96e8\u5929\u751f\u6210\u95ea\u7535\u7684\u51b7\u5374\u65f6\u95f4\nCooldown for spawning lightning when raining").finishValue(arg_0 -> this.reikarlilySpawnLightningCooldown.mirror(arg_0)).finishBranch().fork("bellflower").withComment("\u98ce\u94c3\u8349\nBellflower").beginValue("maxMana", (ConfigType)ConfigTypes.INTEGER, (Object)BellflowerBlockEntity.MAX_MANA).withComment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").finishValue(arg_0 -> this.bellflowerMaxMana.mirror(arg_0)).beginValue("generateModify", (ConfigType)ConfigTypes.DOUBLE, (Object)1.0).withComment("\u9b54\u529b\u751f\u6210\u4fee\u6b63\u503c\nMana generation modifier").finishValue(arg_0 -> this.bellflowerGenerateModify.mirror(arg_0)).finishBranch().fork("annoyingflower").withComment("\u795e\u70e6\u82b1\nAnnoying Flower").beginValue("maxMana", (ConfigType)ConfigTypes.INTEGER, (Object)1000).withComment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").finishValue(arg_0 -> this.annoyingflowerMaxMana.mirror(arg_0)).beginValue("fishingCost", (ConfigType)ConfigTypes.INTEGER, (Object)300).withComment("\u9493\u9c7c\u6d88\u8017\u7684\u9b54\u529b\u91cf\nMana cost per fishing").finishValue(arg_0 -> this.annoyingflowerFishingCost.mirror(arg_0)).beginValue("cooldown", (ConfigType)ConfigTypes.INTEGER, (Object)900).withComment("\u5de5\u4f5c\u51b7\u5374\u65f6\u95f4(ticks)\nCooldown time in ticks").finishValue(arg_0 -> this.annoyingflowerCooldown.mirror(arg_0)).beginValue("foodBoostMax", (ConfigType)ConfigTypes.INTEGER, (Object)12).withComment("\u6700\u5927\u98df\u7269\u52a0\u6210\u6b21\u6570\nMaximum food boost").finishValue(arg_0 -> this.annoyingflowerFoodBoostMax.mirror(arg_0)).beginValue("foodBoostPerEat", (ConfigType)ConfigTypes.INTEGER, (Object)3).withComment("\u6bcf\u6b21\u8fdb\u98df\u589e\u52a0\u7684\u6b21\u6570\nBoost added per food consumed").finishValue(arg_0 -> this.annoyingflowerFoodBoostTimes.mirror(arg_0)).beginValue("foodBoostCooldownMultiplier", (ConfigType)ConfigTypes.DOUBLE, (Object)0.4).withComment("\u98df\u7269\u52a0\u6210\u65f6\u7684\u51b7\u5374\u65f6\u95f4\u4e58\u6570\nCooldown multiplier when food boosted").finishValue(arg_0 -> this.annoyingflowerFoodBoostCooldownMultiplier.mirror(arg_0)).finishBranch().fork("stonesia").withComment("\u77f3\u4e2d\u59ec\nStonesia").beginValue("maxMana", (ConfigType)ConfigTypes.INTEGER, (Object)3200).withComment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").finishValue(arg_0 -> this.stonesiaMaxMana.mirror(arg_0)).beginValue("cooldown", (ConfigType)ConfigTypes.INTEGER, (Object)40).withComment("\u51b7\u5374\u65f6\u95f4(ticks)\nCooldown time in ticks").finishValue(arg_0 -> this.stonesiaCooldown.mirror(arg_0)).finishBranch().fork("edelweiss").withComment("\u96ea\u7ed2\u82b1\nEdelweiss").beginValue("maxMana", (ConfigType)ConfigTypes.INTEGER, (Object)12800).withComment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").finishValue(arg_0 -> this.edelweissMaxMana.mirror(arg_0)).beginValue("cooldown", (ConfigType)ConfigTypes.INTEGER, (Object)40).withComment("\u51b7\u5374\u65f6\u95f4(ticks)\nCooldown time in ticks").finishValue(arg_0 -> this.edelweissCooldown.mirror(arg_0)).finishBranch().fork("resoncund").withComment("\u56de\u97f3\u82b1\nResoncund").beginValue("maxMana", (ConfigType)ConfigTypes.INTEGER, (Object)1200).withComment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").finishValue(arg_0 -> this.resoncundMaxMana.mirror(arg_0)).beginValue("lossPerHeard", (ConfigType)ConfigTypes.INTEGER, (Object)50).withComment("\u540c\u79cd\u58f0\u97f3\u91cd\u590d\u542c\u5230\u540e\u7684\u9b54\u529b\u751f\u4ea7\u8870\u51cf\nMana produce decreases per same sound heard").finishValue(arg_0 -> this.resoncundLossPerHeard.mirror(arg_0)).finishBranch().fork("sunshineLily").withComment("\u65e5\u66dc\u767e\u5408\nSunshine Lily").beginValue("maxMana", (ConfigType)ConfigTypes.INTEGER, (Object)200).withComment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").finishValue(arg_0 -> this.sunshineLilyMaxMana.mirror(arg_0)).beginValue("produceMana", (ConfigType)ConfigTypes.INTEGER, (Object)2).withComment("\u6bcf\u6b21\u751f\u6210\u7684\u9b54\u529b\u91cf\nMana generated per produce").finishValue(arg_0 -> this.sunshineLilyProduceMana.mirror(arg_0)).finishBranch().fork("moonlightLily").withComment("\u6708\u8000\u767e\u5408\nMoonlight Lily").beginValue("maxMana", (ConfigType)ConfigTypes.INTEGER, (Object)200).withComment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").finishValue(arg_0 -> this.moonlightLilyMaxMana.mirror(arg_0)).beginValue("produceMana", (ConfigType)ConfigTypes.INTEGER, (Object)1).withComment("\u6bcf\u6b21\u751f\u6210\u7684\u9b54\u529b\u91cf\nMana generated per produce").finishValue(arg_0 -> this.moonlightLilyProduceMana.mirror(arg_0)).finishBranch().fork("twinstar").withComment("\u53cc\u5b50\u5170\nTwinstar").beginValue("maxMana", (ConfigType)ConfigTypes.INTEGER, (Object)1000).withComment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").finishValue(arg_0 -> this.twinstarMaxMana.mirror(arg_0)).beginValue("maxTemperatureCap", (ConfigType)ConfigTypes.INTEGER, (Object)Integer.MAX_VALUE).withComment("\u6700\u5927\u63a5\u53d7\u6d41\u4f53\u6e29\u5ea6\nMaximum accepted temperature cap for liquid").finishValue(arg_0 -> this.twinstarMaxTemperature.mirror(arg_0)).beginValue("minTemperatureCap", (ConfigType)ConfigTypes.INTEGER, (Object)0).withComment("\u6700\u4f4e\u63a5\u53d7\u6d41\u4f53\u6e29\u5ea6\nMinimum accepted temperature cap for liquid").finishValue(arg_0 -> this.twinstarMinTemperature.mirror(arg_0)).finishBranch().fork("omniviolet").withComment("\u5168\u77e5\u747e\nOmniviolet").beginValue("maxMana", (ConfigType)ConfigTypes.INTEGER, (Object)1500).withComment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").finishValue(arg_0 -> this.omnivioletMaxMana.mirror(arg_0)).finishBranch().fork("tinkle").withComment("\u53ee\u5f53\u82b1\nTinkle").beginValue("maxMana", (ConfigType)ConfigTypes.INTEGER, (Object)1000).withComment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").finishValue(arg_0 -> this.tinkleMaxMana.mirror(arg_0)).beginValue("produceMana", (ConfigType)ConfigTypes.INTEGER, (Object)100).withComment("\u6bcf\u6b21\u751f\u6210\u7684\u9b54\u529b\u91cf\nMana generated per produce").finishValue(arg_0 -> this.tinkleProduceMana.mirror(arg_0)).finishBranch().fork("bloodEnchantress").withComment("\u9c9c\u8840\u5996\u59ec\nBlood Enchantress").beginValue("maxMana", (ConfigType)ConfigTypes.INTEGER, (Object)800).withComment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").finishValue(arg_0 -> this.bloodEnchantressMaxMana.mirror(arg_0)).beginValue("produceMana", (ConfigType)ConfigTypes.INTEGER, (Object)22).withComment("\u6bcf\u6b21\u751f\u6210\u7684\u9b54\u529b\u91cf\nMana generated per produce").finishValue(arg_0 -> this.bloodEnchantressProduceMana.mirror(arg_0)).finishBranch().fork("serenitian").withComment("\u6c38\u5bc2\u9f99\u80c6\nSerenitian").beginValue("range", (ConfigType)ConfigTypes.INTEGER, (Object)3).withComment("\u4f5c\u7528\u8303\u56f4(\u65b9\u5757\u534a\u5f84)\nWorking range in blocks").finishValue(arg_0 -> this.serenitianRange.mirror(arg_0)).finishBranch().fork("mirrowtunia").withComment("\u955c\u59ec\nMirrowtunia").beginValue("maxMana", (ConfigType)ConfigTypes.INTEGER, (Object)2000).withComment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").finishValue(arg_0 -> this.mirrowtuniaMaxMana.mirror(arg_0)).beginValue("effectCost", (ConfigType)ConfigTypes.INTEGER, (Object)100).withComment("\u65bd\u52a0\u6548\u679c\u6d88\u8017\u7684\u9b54\u529b\u91cf\nMana cost per effect").finishValue(arg_0 -> this.mirrowtuniaEffectCost.mirror(arg_0)).finishBranch().fork("necrofleur").withComment("\u6b7b\u4e4b\u82b1\nNecrofleur").beginValue("maxMana", (ConfigType)ConfigTypes.INTEGER, (Object)200).withComment("\u6700\u5927\u9b54\u529b\u503c\nMaximum mana").finishValue(arg_0 -> this.necrofleurMaxMana.mirror(arg_0)).finishBranch().fork("manalink").withComment("\u9b54\u94fe\u661f\nManalink").beginValue("transferSpeed", (ConfigType)ConfigTypes.INTEGER, (Object)400).withComment("\u9b54\u529b\u4f20\u8f93\u901f\u5ea6\nMana transfer speed").finishValue(arg_0 -> this.manalinkTransferSpeed.mirror(arg_0)).finishBranch().fork("enchanter").withComment("\u8574\u9b54\u747e\nEnchanter").beginValue("transformCost", (ConfigType)ConfigTypes.INTEGER, (Object)250000).withComment("\u8f6c\u6362\u8349\u65b9\u5757\u4e3a\u8574\u9b54\u571f\u7684\u603b\u6d88\u8017\nTotal mana cost to transform grass to enchanted soil").finishValue(arg_0 -> this.enchanterTransformCost.mirror(arg_0)).beginValue("consumeSpeed", (ConfigType)ConfigTypes.INTEGER, (Object)400).withComment("\u9b54\u529b\u6d88\u8017\u901f\u5ea6\nMana consume speed").finishValue(arg_0 -> this.enchanterConsumeSpeed.mirror(arg_0)).finishBranch().finishBranch().finishBranch();
            return builder.build();
        }

        @Override
        public boolean disableGaiaDisArm() {
            return (Boolean)this.disableGaiaDisArm.getValue();
        }

        @Override
        public boolean enableTelemetry() {
            return (Boolean)this.enableTelemetry.getValue();
        }

        @Override
        public String telemetryUUID() {
            return (String)this.telemetryUUID.getValue();
        }

        @Override
        public String fakePlayerId() {
            return (String)this.fakePlayerId.getValue();
        }

        @Override
        public int[] woodieniaRange() {
            return (int[])this.woodieniaRange.getValue();
        }

        @Override
        public int woodieniaCooldown() {
            return (Integer)this.woodieniaCooldown.getValue();
        }

        @Override
        public int woodieniaMaxMana() {
            return (Integer)this.woodieniaMaxMana.getValue();
        }

        @Override
        public int woodieniaWorkManaCost() {
            return (Integer)this.woodieniaWorkManaCost.getValue();
        }

        @Override
        public int reikarlilyMaxMana() {
            return (Integer)this.reikarlilyMaxMana.getValue();
        }

        @Override
        public int reikarlilyProduceCooldown() {
            return (Integer)this.reikarlilyProduceCooldown.getValue();
        }

        @Override
        public int reikarlilyProduceMana() {
            return (Integer)this.reikarlilyProduceMana.getValue();
        }

        @Override
        public int reikarlilyPassiveGenerateTime() {
            return (Integer)this.reikarlilyPassiveGenerateTime.getValue();
        }

        @Override
        public int reikarlilyPassiveGenerateMana() {
            return (Integer)this.reikarlilyPassiveGenerateMana.getValue();
        }

        @Override
        public int reikarlilySpawnLightningCooldown() {
            return (Integer)this.reikarlilySpawnLightningCooldown.getValue();
        }

        @Override
        public int tradeOrchidMaxMana() {
            return (Integer)this.tradeOrchidMaxMana.getValue();
        }

        @Override
        public int tradeOrchidCooldown() {
            return (Integer)this.tradeOrchidCooldown.getValue();
        }

        @Override
        public int tradeOrchidManaCost() {
            return (Integer)this.tradeOrchidManaCost.getValue();
        }

        @Override
        public double tradeOrchidDiscountPercentage() {
            return (Double)this.tradeOrchidDiscountPercentage.getValue();
        }

        @Override
        public int bellflowerMaxMana() {
            return (Integer)this.bellflowerMaxMana.getValue();
        }

        @Override
        public double bellflowerGenerateModify() {
            return (Double)this.bellflowerGenerateModify.getValue();
        }

        @Override
        public int annoyingflowerMaxMana() {
            return (Integer)this.annoyingflowerMaxMana.getValue();
        }

        @Override
        public int annoyingflowerFishingCost() {
            return (Integer)this.annoyingflowerFishingCost.getValue();
        }

        @Override
        public int annoyingflowerCooldown() {
            return (Integer)this.annoyingflowerCooldown.getValue();
        }

        @Override
        public int annoyingflowerFoodBoostMax() {
            return (Integer)this.annoyingflowerFoodBoostMax.getValue();
        }

        @Override
        public int annoyingflowerFoodBoostTimes() {
            return (Integer)this.annoyingflowerFoodBoostTimes.getValue();
        }

        @Override
        public double annoyingflowerFoodBoostCooldownMultiplier() {
            return (Double)this.annoyingflowerFoodBoostCooldownMultiplier.getValue();
        }

        @Override
        public int stonesiaMaxMana() {
            return (Integer)this.stonesiaMaxMana.getValue();
        }

        @Override
        public int stonesiaCooldown() {
            return (Integer)this.stonesiaCooldown.getValue();
        }

        @Override
        public int edelweissMaxMana() {
            return (Integer)this.edelweissMaxMana.getValue();
        }

        @Override
        public int edelweissCooldown() {
            return (Integer)this.edelweissCooldown.getValue();
        }

        @Override
        public int resoncundMaxMana() {
            return (Integer)this.resoncundMaxMana.getValue();
        }

        @Override
        public int resoncundLossPerHeard() {
            return (Integer)this.resoncundLossPerHeard.getValue();
        }

        @Override
        public int sunshineLilyMaxMana() {
            return (Integer)this.sunshineLilyMaxMana.getValue();
        }

        @Override
        public int sunshineLilyProduceMana() {
            return (Integer)this.sunshineLilyProduceMana.getValue();
        }

        @Override
        public int moonlightLilyMaxMana() {
            return (Integer)this.moonlightLilyMaxMana.getValue();
        }

        @Override
        public int moonlightLilyProduceMana() {
            return (Integer)this.moonlightLilyProduceMana.getValue();
        }

        @Override
        public int twinstarMaxMana() {
            return (Integer)this.twinstarMaxMana.getValue();
        }

        @Override
        public int twinstarMaxTemperature() {
            return (Integer)this.twinstarMaxTemperature.getValue();
        }

        @Override
        public int twinstarMinTemperature() {
            return (Integer)this.twinstarMinTemperature.getValue();
        }

        @Override
        public int omnivioletMaxMana() {
            return (Integer)this.omnivioletMaxMana.getValue();
        }

        @Override
        public int tinkleMaxMana() {
            return (Integer)this.tinkleMaxMana.getValue();
        }

        @Override
        public int tinkleProduceMana() {
            return (Integer)this.tinkleProduceMana.getValue();
        }

        @Override
        public int bloodEnchantressMaxMana() {
            return (Integer)this.bloodEnchantressMaxMana.getValue();
        }

        @Override
        public int bloodEnchantressProduceMana() {
            return (Integer)this.bloodEnchantressProduceMana.getValue();
        }

        @Override
        public int serenitianRange() {
            return (Integer)this.serenitianRange.getValue();
        }

        @Override
        public int mirrowtuniaMaxMana() {
            return (Integer)this.mirrowtuniaMaxMana.getValue();
        }

        @Override
        public int mirrowtuniaEffectCost() {
            return (Integer)this.mirrowtuniaEffectCost.getValue();
        }

        @Override
        public int necrofleurMaxMana() {
            return (Integer)this.necrofleurMaxMana.getValue();
        }

        @Override
        public int manalinkTransferSpeed() {
            return (Integer)this.manalinkTransferSpeed.getValue();
        }

        @Override
        public int enchanterTransformCost() {
            return (Integer)this.enchanterTransformCost.getValue();
        }

        @Override
        public int enchanterConsumeSpeed() {
            return (Integer)this.enchanterConsumeSpeed.getValue();
        }

        @Override
        public List<String> gaiaSpawnUnCheckList() {
            return (List)this.gaiaSpawnUnCheckList.getValue();
        }
    }

    private static class Client
    implements ExtraBotanyConfig.ClientConfigAccess {
        public final PropertyMirror<Boolean> otakuMode = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);

        private Client() {
        }

        public ConfigTree configure(ConfigTreeBuilder builder) {
            builder.fork("client").beginValue("otakuMode", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("\u8bbe\u4e3a true \u6765\u5f00\u542f\u4e8c\u523a\u8788\u6a21\u5f0f\n\uff08\u5c06\u4f1a\u542f\u7528\u4e00\u4e9b\u6d53\u5ea6\u8f83\u9ad8\u3001\u53d1\u766b\u7684\u6587\u672c\u663e\u793a\uff09\n\nSet true to enable Otaku Mode.\n(Enables otaku-style text display)\n").finishValue(arg_0 -> this.otakuMode.mirror(arg_0)).finishBranch();
            return builder.build();
        }

        @Override
        public boolean otakuMode() {
            return (Boolean)this.otakuMode.getValue();
        }
    }
}

