/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.fabric.network;

import io.github.lounode.extrabotany.client.gui.HUD;
import io.github.lounode.extrabotany.network.clientbound.ColorfulBossEventPacket;
import io.github.lounode.extrabotany.network.clientbound.GaiaBossEventPacket;
import io.github.lounode.extrabotany.network.clientbound.ManaReaderPacket;
import io.github.lounode.extrabotany.network.clientbound.SpawnGaiaPacket;
import io.github.lounode.extrabotany.network.serverbound.LeftClickPacketExcalibur;
import io.github.lounode.extrabotany.network.serverbound.LeftClickPacketJingwei;
import io.github.lounode.extrabotany.network.serverbound.LeftClickPacketVoidArchives;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import vazkii.botania.network.TriConsumer;

public class FabricPacketHandler {
    private FabricPacketHandler() {
    }

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)LeftClickPacketExcalibur.ID, (ServerPlayNetworking.PlayChannelHandler)FabricPacketHandler.makeServerBoundHandler(LeftClickPacketExcalibur::decode, LeftClickPacketExcalibur::handle));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)LeftClickPacketJingwei.ID, (ServerPlayNetworking.PlayChannelHandler)FabricPacketHandler.makeServerBoundHandler(LeftClickPacketJingwei::decode, LeftClickPacketJingwei::handle));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)LeftClickPacketVoidArchives.ID, (ServerPlayNetworking.PlayChannelHandler)FabricPacketHandler.makeServerBoundHandler(LeftClickPacketVoidArchives::decode, LeftClickPacketVoidArchives::handle));
        FabricPacketHandler.registerOperation();
    }

    public static void initClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ManaReaderPacket.ID, (ClientPlayNetworking.PlayChannelHandler)FabricPacketHandler.makeClientBoundHandler(ManaReaderPacket::decode, ManaReaderPacket.Handler::handle));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpawnGaiaPacket.ID, (ClientPlayNetworking.PlayChannelHandler)FabricPacketHandler.makeClientBoundHandler(SpawnGaiaPacket::decode, SpawnGaiaPacket.Handler::handle));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ColorfulBossEventPacket.ID, (ClientPlayNetworking.PlayChannelHandler)FabricPacketHandler.makeClientBoundHandler(ColorfulBossEventPacket::decode, packet -> HUD.getInstance().getBossOverlay().update((ColorfulBossEventPacket)packet)));
    }

    private static void registerOperation() {
        ColorfulBossEventPacket.Operation.register("add", () -> ColorfulBossEventPacket.AddOperation.CODEC);
        ColorfulBossEventPacket.Operation.register("remove", () -> ColorfulBossEventPacket.RemoveOperation.CODEC);
        ColorfulBossEventPacket.Operation.register("update_progress", () -> ColorfulBossEventPacket.UpdateProgressOperation.CODEC);
        ColorfulBossEventPacket.Operation.register("update_name", () -> ColorfulBossEventPacket.UpdateNameOperation.CODEC);
        ColorfulBossEventPacket.Operation.register("update_style", () -> ColorfulBossEventPacket.UpdateStyleOperation.CODEC);
        ColorfulBossEventPacket.Operation.register("update_properties", () -> ColorfulBossEventPacket.UpdatePropertiesOperation.CODEC);
        ColorfulBossEventPacket.Operation.register("update_player_count", () -> GaiaBossEventPacket.UpdatePlayerCountOperation.CODEC);
        ColorfulBossEventPacket.Operation.register("update_grain_time", () -> GaiaBossEventPacket.UpdateGrainTimeOperation.CODEC);
    }

    private static <T> ServerPlayNetworking.PlayChannelHandler makeServerBoundHandler(Function<class_2540, T> decoder, TriConsumer<T, MinecraftServer, class_3222> handle) {
        return (server, player, _handler, buf, _responseSender) -> handle.accept(decoder.apply(buf), (Object)server, (Object)player);
    }

    private static <T> ClientPlayNetworking.PlayChannelHandler makeClientBoundHandler(Function<class_2540, T> decoder, Consumer<T> handler) {
        return (_client, _handler, buf, _responseSender) -> handler.accept(decoder.apply(buf));
    }
}

