/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.network.clientbound;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lounode.extrabotany.common.bossevents.ComponentCodec;
import io.github.lounode.extrabotany.network.ExtrabotanyPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1259;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import vazkii.botania.common.lib.ResourceLocationHelper;

public record ColorfulBossEventPacket(UUID id, Operation operation) implements ExtrabotanyPacket
{
    public static final Codec<class_1259.class_1260> BOSSBAR_COLOR_CODEC = Codec.STRING.xmap(class_1259.class_1260::valueOf, Enum::name);
    public static final Codec<class_1259.class_1261> BOSSBAR_OVERLAY_CODEC = Codec.STRING.xmap(class_1259.class_1261::valueOf, Enum::name);
    public static final class_2960 ID = ResourceLocationHelper.prefix((String)"cbp");

    @Override
    public class_2960 getFabricId() {
        return ID;
    }

    @Override
    public void encode(class_2540 buf) {
        buf.method_10797(this.id);
        buf.method_49395(this.operation().getCodec(), (Object)this.operation());
    }

    public static ColorfulBossEventPacket decode(class_2540 buf) {
        return new ColorfulBossEventPacket(buf.method_10790(), (Operation)buf.method_49394(Operation.CODEC));
    }

    public static ColorfulBossEventPacket createAddPacket(class_1259 event) {
        return new ColorfulBossEventPacket(event.method_5407(), AddOperation.form(event));
    }

    public static ColorfulBossEventPacket createRemovePacket(UUID id) {
        return new ColorfulBossEventPacket(id, new RemoveOperation(id));
    }

    public static ColorfulBossEventPacket createUpdateProgressPacket(class_1259 event) {
        return new ColorfulBossEventPacket(event.method_5407(), new UpdateProgressOperation(event.method_5412()));
    }

    public static ColorfulBossEventPacket createUpdateNamePacket(class_1259 event) {
        return new ColorfulBossEventPacket(event.method_5407(), new UpdateNameOperation(event.method_5414()));
    }

    public static ColorfulBossEventPacket createUpdateStylePacket(class_1259 event) {
        return new ColorfulBossEventPacket(event.method_5407(), new UpdateStyleOperation(event.method_5420(), event.method_5415()));
    }

    public static ColorfulBossEventPacket createUpdatePropertiesPacket(class_1259 event) {
        return new ColorfulBossEventPacket(event.method_5407(), new UpdatePropertiesOperation(event.method_5417(), event.method_5418(), event.method_5419()));
    }

    public void dispatch(Handler handler) {
        this.operation.dispatch(this.id, handler);
    }

    public static interface Operation {
        public static final Map<String, Supplier<Codec<? extends Operation>>> REGISTRY = new HashMap<String, Supplier<Codec<? extends Operation>>>();
        public static final Codec<Operation> CODEC = Codec.STRING.dispatch(Operation::getType, type -> REGISTRY.getOrDefault(type, () -> {
            throw new IllegalArgumentException("Unknown operation type: " + type);
        }).get());

        public Codec<? extends Operation> getCodec();

        public void dispatch(UUID var1, Handler var2);

        public String getType();

        public static void register(String type, Supplier<Codec<? extends Operation>> codecSupplier) {
            REGISTRY.put(type, codecSupplier);
        }
    }

    public record AddOperation(class_2561 name, float progress, class_1259.class_1260 color, class_1259.class_1261 overlay, boolean darkenScreen, boolean playMusic, boolean createWorldFog) implements Operation
    {
        public static final Codec<AddOperation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(AddOperation::getType), (App)ComponentCodec.CODEC.fieldOf("name").forGetter(AddOperation::name), (App)Codec.FLOAT.fieldOf("progress").forGetter(AddOperation::progress), (App)BOSSBAR_COLOR_CODEC.fieldOf("color").forGetter(AddOperation::color), (App)BOSSBAR_OVERLAY_CODEC.fieldOf("overlay").forGetter(AddOperation::overlay), (App)Codec.BOOL.fieldOf("darkenScreen").forGetter(AddOperation::darkenScreen), (App)Codec.BOOL.fieldOf("playMusic").forGetter(AddOperation::playMusic), (App)Codec.BOOL.fieldOf("createWorldFog").forGetter(AddOperation::createWorldFog)).apply((Applicative)instance, (type, name, progress, color, overlay, darkenScreen, playMusic, createWorldFog) -> new AddOperation((class_2561)name, progress.floatValue(), (class_1259.class_1260)color, (class_1259.class_1261)overlay, (boolean)darkenScreen, (boolean)playMusic, (boolean)createWorldFog)));

        public static AddOperation form(class_1259 event) {
            return new AddOperation(event.method_5414(), event.method_5412(), event.method_5420(), event.method_5415(), event.method_5417(), event.method_5418(), event.method_5419());
        }

        @Override
        public String getType() {
            return "add";
        }

        @Override
        public Codec<? extends Operation> getCodec() {
            return CODEC;
        }

        @Override
        public void dispatch(UUID uuid, Handler handler) {
            handler.add(uuid, this.name, this.progress, this.color, this.overlay, this.darkenScreen, this.playMusic, this.createWorldFog);
        }
    }

    public record RemoveOperation(UUID uuid) implements Operation
    {
        public static final Codec<RemoveOperation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(RemoveOperation::getType), (App)Codec.STRING.xmap(UUID::fromString, UUID::toString).fieldOf("uuid").forGetter(RemoveOperation::uuid)).apply((Applicative)instance, (type, uuid) -> new RemoveOperation((UUID)uuid)));

        @Override
        public String getType() {
            return "remove";
        }

        @Override
        public Codec<? extends Operation> getCodec() {
            return CODEC;
        }

        @Override
        public void dispatch(UUID uuid, Handler handler) {
            handler.remove(uuid);
        }
    }

    public record UpdateProgressOperation(float progress) implements Operation
    {
        public static final Codec<UpdateProgressOperation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(UpdateProgressOperation::getType), (App)Codec.FLOAT.fieldOf("progress").forGetter(UpdateProgressOperation::progress)).apply((Applicative)instance, (type, progress) -> new UpdateProgressOperation(progress.floatValue())));

        @Override
        public String getType() {
            return "update_progress";
        }

        @Override
        public Codec<? extends Operation> getCodec() {
            return CODEC;
        }

        @Override
        public void dispatch(UUID uuid, Handler handler) {
            handler.updateProgress(uuid, this.progress());
        }
    }

    public record UpdateNameOperation(class_2561 name) implements Operation
    {
        public static final Codec<UpdateNameOperation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(UpdateNameOperation::getType), (App)ComponentCodec.CODEC.fieldOf("name").forGetter(UpdateNameOperation::name)).apply((Applicative)instance, (type, name) -> new UpdateNameOperation((class_2561)name)));

        @Override
        public Codec<? extends Operation> getCodec() {
            return CODEC;
        }

        @Override
        public void dispatch(UUID uuid, Handler handler) {
            handler.updateName(uuid, this.name());
        }

        @Override
        public String getType() {
            return "update_name";
        }
    }

    public record UpdateStyleOperation(class_1259.class_1260 color, class_1259.class_1261 overlay) implements Operation
    {
        public static final Codec<UpdateStyleOperation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(UpdateStyleOperation::getType), (App)BOSSBAR_COLOR_CODEC.fieldOf("color").forGetter(UpdateStyleOperation::color), (App)BOSSBAR_OVERLAY_CODEC.fieldOf("overlay").forGetter(UpdateStyleOperation::overlay)).apply((Applicative)instance, (type, color, overlay) -> new UpdateStyleOperation((class_1259.class_1260)color, (class_1259.class_1261)overlay)));

        @Override
        public Codec<? extends Operation> getCodec() {
            return CODEC;
        }

        @Override
        public void dispatch(UUID uuid, Handler handler) {
            handler.updateStyle(uuid, this.color(), this.overlay());
        }

        @Override
        public String getType() {
            return "update_style";
        }
    }

    public record UpdatePropertiesOperation(boolean darkenScreen, boolean playMusic, boolean createWorldFog) implements Operation
    {
        public static final Codec<UpdatePropertiesOperation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(UpdatePropertiesOperation::getType), (App)Codec.BOOL.fieldOf("darkenScreen").forGetter(UpdatePropertiesOperation::darkenScreen), (App)Codec.BOOL.fieldOf("playMusic").forGetter(UpdatePropertiesOperation::playMusic), (App)Codec.BOOL.fieldOf("createWorldFog").forGetter(UpdatePropertiesOperation::createWorldFog)).apply((Applicative)instance, (type, darkenScreen, playMusic, createWorldFog) -> new UpdatePropertiesOperation((boolean)darkenScreen, (boolean)playMusic, (boolean)createWorldFog)));

        @Override
        public Codec<? extends Operation> getCodec() {
            return CODEC;
        }

        @Override
        public void dispatch(UUID uuid, Handler handler) {
            handler.updateProperties(uuid, this.darkenScreen(), this.playMusic(), this.createWorldFog());
        }

        @Override
        public String getType() {
            return "update_properties";
        }
    }

    public static interface Handler {
        default public void add(UUID uuid, class_2561 name, float progress, class_1259.class_1260 color, class_1259.class_1261 overlay, boolean darkenScreen, boolean playMusic, boolean createWorldFog) {
        }

        default public void remove(UUID uuid) {
        }

        default public void updateProgress(UUID uuid, float progress) {
        }

        default public void updateName(UUID uuid, class_2561 name) {
        }

        default public void updateStyle(UUID uuid, class_1259.class_1260 color, class_1259.class_1261 overlay) {
        }

        default public void updateProperties(UUID uuid, boolean darkenScreen, boolean playMusic, boolean createWorldFog) {
        }
    }
}

