/*
 * Decompiled with CFR 0.152.
 */
package com.fisfis.vanishultimate;

import com.fisfis.vanishultimate.VanishManager;
import com.fisfis.vanishultimate.VanishUltimate;
import java.util.Iterator;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatListener
implements Listener {
    private final VanishUltimate plugin;

    public ChatListener(VanishUltimate plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player sender = event.getPlayer();
        VanishManager vanishManager = this.plugin.getVanishManager();
        if (vanishManager.isVanished(sender)) {
            String format = this.plugin.getConfig().getString("messages.vanish-chat-format", "&8&l[&5&lVANISH&8&l] &d{player}: &7{message}");
            format = ChatColor.translateAlternateColorCodes((char)'&', (String)format);
            format = format.replace("{player}", "%1$s").replace("{message}", "%2$s");
            event.setFormat(format);
            Iterator recipients = event.getRecipients().iterator();
            while (recipients.hasNext()) {
                Player recipient = (Player)recipients.next();
                if (recipient.hasPermission("vanish.see")) continue;
                recipients.remove();
            }
        }
    }
}

