/*
 * Decompiled with CFR 0.152.
 */
package com.fisfis.vanishultimate;

import com.fisfis.vanishultimate.VanishUltimate;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataManager {
    private final VanishUltimate plugin;
    private FileConfiguration dataConfig = null;
    private File configFile = null;

    public DataManager(VanishUltimate plugin) {
        this.plugin = plugin;
        plugin.saveDefaultConfig();
        this.saveDefaultDataFile();
    }

    public void reloadConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), "vanished-players.yml");
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public FileConfiguration getConfig() {
        if (this.dataConfig == null) {
            this.reloadConfig();
        }
        return this.dataConfig;
    }

    public void saveConfig() {
        if (this.dataConfig == null || this.configFile == null) {
            return;
        }
        try {
            this.getConfig().save(this.configFile);
        }
        catch (IOException ex) {
            this.plugin.getLogger().severe("Could not save config to " + String.valueOf(this.configFile));
        }
    }

    public void saveDefaultDataFile() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), "vanished-players.yml");
        }
        if (!this.configFile.exists()) {
            this.plugin.saveResource("vanished-players.yml", false);
        }
    }

    public void loadVanishData() {
        Set<UUID> vanishedPlayers = this.getConfig().getStringList("vanished-uuids").stream().map(UUID::fromString).collect(Collectors.toSet());
        this.plugin.getVanishManager().loadVanishedPlayers(vanishedPlayers);
    }

    public void saveVanishData() {
        List vanishedUUIDs = this.plugin.getVanishManager().getVanishedPlayers().stream().map(UUID::toString).collect(Collectors.toList());
        this.getConfig().set("vanished-uuids", vanishedUUIDs);
        this.saveConfig();
    }

    public long getVanishTime(UUID uuid) {
        return this.getConfig().getLong("player-times." + uuid.toString(), 0L);
    }

    public void setVanishTime(UUID uuid, long time) {
        this.getConfig().set("player-times." + uuid.toString(), (Object)time);
        this.saveConfig();
    }

    public Component getMessage(String key, String ... replacements) {
        String message = this.plugin.getConfig().getString(key, "&cMesaj bulunamad\u0131: " + key);
        if (replacements.length > 0) {
            for (int i = 0; i < replacements.length; i += 2) {
                if (i + 1 >= replacements.length) continue;
                message = message.replace(replacements[i], replacements[i + 1]);
            }
        }
        return LegacyComponentSerializer.legacyAmpersand().deserialize(message);
    }

    public long getMaxVanishTime() {
        return this.plugin.getConfig().getLong("max-vanish-time", 3600L);
    }

    public void incrementTotalVanishTime(UUID uuid, int seconds) {
        long currentTime = this.getVanishTime(uuid);
        this.setVanishTime(uuid, currentTime + (long)seconds);
    }
}

