/*
 * Decompiled with CFR 0.152.
 */
package com.fisfis.vanishultimate;

import com.fisfis.vanishultimate.DataManager;
import com.fisfis.vanishultimate.VanishManager;
import com.fisfis.vanishultimate.VanishUltimate;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    private final VanishUltimate plugin;
    private final VanishManager vanishManager;

    public PlayerListener(VanishUltimate plugin) {
        this.plugin = plugin;
        this.vanishManager = plugin.getVanishManager();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        VanishManager vanishManager = this.plugin.getVanishManager();
        DataManager dataManager = this.plugin.getDataManager();
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            if (!vanishManager.isVanished(onlinePlayer) || player.hasPermission("vanish.see")) continue;
            player.hidePlayer((Plugin)this.plugin, onlinePlayer);
        }
        if (vanishManager.isVanished(player)) {
            Component joinMessage = event.joinMessage();
            event.joinMessage(null);
            if (joinMessage != null) {
                for (Player onlinePlayer : Bukkit.getServer().getOnlinePlayers()) {
                    if (!onlinePlayer.hasPermission("vanish.see")) continue;
                    onlinePlayer.sendMessage(joinMessage);
                }
            }
            player.sendMessage(dataManager.getMessage("messages.vanished", new String[0]));
            this.plugin.getVanishTimer().playerVanished(player.getUniqueId());
            for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
                if (onlinePlayer.getUniqueId().equals(player.getUniqueId()) || onlinePlayer.hasPermission("vanish.see")) continue;
                onlinePlayer.hidePlayer((Plugin)this.plugin, player);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        VanishManager vanishManager = this.plugin.getVanishManager();
        if (vanishManager.isVanished(player)) {
            Component quitMessage = event.quitMessage();
            event.quitMessage(null);
            if (quitMessage != null) {
                for (Player onlinePlayer : Bukkit.getServer().getOnlinePlayers()) {
                    if (!onlinePlayer.hasPermission("vanish.see")) continue;
                    onlinePlayer.sendMessage(quitMessage);
                }
            }
            this.plugin.getVanishTimer().playerUnvanished(player.getUniqueId());
        }
    }
}

