/*
 * Decompiled with CFR 0.152.
 */
package com.fisfis.vanishultimate;

import com.fisfis.vanishultimate.DataManager;
import com.fisfis.vanishultimate.VanishManager;
import com.fisfis.vanishultimate.VanishUltimate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class VanishCommand
implements CommandExecutor,
TabCompleter {
    private final VanishUltimate plugin;
    private final VanishManager vanishManager;
    private final DataManager dataManager;

    public VanishCommand(VanishUltimate plugin) {
        this.plugin = plugin;
        this.vanishManager = plugin.getVanishManager();
        this.dataManager = plugin.getDataManager();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommand;
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.dataManager.getMessage("messages.player-only", new String[0]));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("vanish")) {
                player.sendMessage(this.dataManager.getMessage("messages.no-permission", new String[0]));
                return true;
            }
            this.vanishManager.setVanish(player, !this.vanishManager.isVanished(player));
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "time": {
                if (!sender.hasPermission("vanish.time")) {
                    sender.sendMessage(this.dataManager.getMessage("messages.no-permission", new String[0]));
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(this.dataManager.getMessage("messages.usage", new String[0]));
                    return true;
                }
                Player timeTarget = Bukkit.getPlayer((String)args[1]);
                if (timeTarget == null) {
                    sender.sendMessage(this.dataManager.getMessage("messages.player-not-found", "{player}", args[1]));
                    return true;
                }
                long totalTime = this.dataManager.getVanishTime(timeTarget.getUniqueId());
                String formattedTime = this.formatTime(totalTime);
                sender.sendMessage(this.dataManager.getMessage("messages.admin-time-check", "{player}", timeTarget.getName(), "{time}", formattedTime));
                return true;
            }
            case "list": {
                if (!sender.hasPermission("vanish.list")) {
                    sender.sendMessage(this.dataManager.getMessage("messages.no-permission", new String[0]));
                    return true;
                }
                ArrayList<String> vanishedPlayerNames = new ArrayList<String>();
                for (UUID uuid : this.vanishManager.getVanishedPlayers()) {
                    Player p = Bukkit.getPlayer((UUID)uuid);
                    if (p == null) continue;
                    vanishedPlayerNames.add(p.getName());
                }
                if (vanishedPlayerNames.isEmpty()) {
                    sender.sendMessage(this.dataManager.getMessage("messages.vanish-list-empty", new String[0]));
                    return true;
                }
                String headerFormat = this.plugin.getConfig().getString("messages.vanish-list-header", "&5Vanished Players &d({count}):");
                String entryFormat = this.plugin.getConfig().getString("messages.vanish-list-entry", "&d- {player}");
                String header = headerFormat.replace("{count}", String.valueOf(vanishedPlayerNames.size()));
                sender.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(header));
                for (String name : vanishedPlayerNames) {
                    String entry = entryFormat.replace("{player}", name);
                    sender.sendMessage((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(entry));
                }
                return true;
            }
            case "reset": {
                if (!sender.hasPermission("vanish.time")) {
                    sender.sendMessage(this.dataManager.getMessage("messages.no-permission", new String[0]));
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(this.dataManager.getMessage("messages.usage", new String[0]));
                    return true;
                }
                Player resetTarget = Bukkit.getPlayer((String)args[1]);
                if (resetTarget == null) {
                    sender.sendMessage(this.dataManager.getMessage("messages.player-not-found", "{player}", args[1]));
                    return true;
                }
                this.dataManager.setVanishTime(resetTarget.getUniqueId(), 0L);
                sender.sendMessage(this.dataManager.getMessage("messages.admin-time-reset", "{player}", resetTarget.getName()));
                return true;
            }
        }
        if (!sender.hasPermission("vanish.other")) {
            sender.sendMessage(this.dataManager.getMessage("messages.no-permission", new String[0]));
            return true;
        }
        Player otherTarget = Bukkit.getPlayer((String)args[0]);
        if (otherTarget == null) {
            sender.sendMessage(this.dataManager.getMessage("messages.player-not-found", "{player}", args[0]));
            return true;
        }
        boolean isVanished = this.vanishManager.isVanished(otherTarget);
        this.vanishManager.setVanish(otherTarget, !isVanished);
        if (!isVanished) {
            sender.sendMessage(this.dataManager.getMessage("messages.admin-vanished", "{player}", otherTarget.getName()));
        } else {
            sender.sendMessage(this.dataManager.getMessage("messages.admin-unvanished", "{player}", otherTarget.getName()));
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if (sender.hasPermission("vanish.other")) {
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList()));
            }
            if (sender.hasPermission("vanish.time")) {
                if ("time".startsWith(args[0].toLowerCase())) {
                    completions.add("time");
                }
                if ("reset".startsWith(args[0].toLowerCase())) {
                    completions.add("reset");
                }
            }
            return completions;
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("time") || args[0].equalsIgnoreCase("reset")) && sender.hasPermission("vanish.time")) {
            return Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private String formatTime(long totalSeconds) {
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%d d, %d h, %d m, %d s", days, hours, minutes, seconds);
    }
}

