/*
 * Decompiled with CFR 0.152.
 */
package com.fisfis.vanishultimate;

import com.fisfis.vanishultimate.DataManager;
import com.fisfis.vanishultimate.VanishTimer;
import com.fisfis.vanishultimate.VanishUltimate;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class VanishManager {
    private final VanishUltimate plugin;
    private final Set<UUID> vanishedPlayers = new HashSet<UUID>();
    private final DataManager dataManager;
    private final VanishTimer vanishTimer;

    public VanishManager(VanishUltimate plugin) {
        this.plugin = plugin;
        this.dataManager = plugin.getDataManager();
        this.vanishTimer = plugin.getVanishTimer();
    }

    public boolean isVanished(Player player) {
        return this.vanishedPlayers.contains(player.getUniqueId());
    }

    public Set<UUID> getVanishedPlayers() {
        return this.vanishedPlayers;
    }

    public void setVanish(Player player, boolean vanish) {
        if (vanish) {
            this.vanishedPlayers.add(player.getUniqueId());
            this.vanishTimer.playerVanished(player.getUniqueId());
            player.sendMessage(this.dataManager.getMessage("messages.vanished", new String[0]));
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!onlinePlayer.hasPermission("vanish.see") || onlinePlayer.equals((Object)player)) continue;
                onlinePlayer.sendMessage(this.dataManager.getMessage("messages.other-player-vanished", "{player}", player.getName()));
            }
            this.updatePlayerVisibility(player, true);
        } else {
            this.vanishedPlayers.remove(player.getUniqueId());
            this.vanishTimer.playerUnvanished(player.getUniqueId());
            player.sendMessage(this.dataManager.getMessage("messages.unvanished", new String[0]));
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!onlinePlayer.hasPermission("vanish.see") || onlinePlayer.equals((Object)player)) continue;
                onlinePlayer.sendMessage(this.dataManager.getMessage("messages.other-player-unvanished", "{player}", player.getName()));
            }
            this.updatePlayerVisibility(player, false);
        }
        this.dataManager.saveVanishData();
    }

    public void updatePlayerVisibility(Player vanishedPlayer, boolean isVanishing) {
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (vanishedPlayer.equals((Object)onlinePlayer)) continue;
            if (isVanishing) {
                if (onlinePlayer.hasPermission("vanish.see")) continue;
                onlinePlayer.hidePlayer((Plugin)this.plugin, vanishedPlayer);
                continue;
            }
            onlinePlayer.showPlayer((Plugin)this.plugin, vanishedPlayer);
        }
    }

    public void handlePlayerJoin(Player joinedPlayer) {
        for (UUID vanishedUUID : this.vanishedPlayers) {
            Player vanishedPlayer = Bukkit.getPlayer((UUID)vanishedUUID);
            if (vanishedPlayer == null || !vanishedPlayer.isOnline() || joinedPlayer.hasPermission("vanish.see")) continue;
            joinedPlayer.hidePlayer((Plugin)this.plugin, vanishedPlayer);
        }
    }

    public void loadVanishedPlayers(Set<UUID> loadedUuids) {
        this.vanishedPlayers.clear();
        this.vanishedPlayers.addAll(loadedUuids);
    }
}

