/*
 * Decompiled with CFR 0.152.
 */
package com.fisfis.vanishultimate;

import com.fisfis.vanishultimate.DataManager;
import com.fisfis.vanishultimate.VanishManager;
import com.fisfis.vanishultimate.VanishUltimate;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class VanishTimer
extends BukkitRunnable {
    private final VanishUltimate plugin;
    private final Map<UUID, Long> vanishStartTime = new HashMap<UUID, Long>();

    public VanishTimer(VanishUltimate plugin) {
        this.plugin = plugin;
    }

    public void run() {
        VanishManager vanishManager = this.plugin.getVanishManager();
        DataManager dataManager = this.plugin.getDataManager();
        if (vanishManager == null || dataManager == null) {
            return;
        }
        for (UUID uuid : vanishManager.getVanishedPlayers()) {
            long maxVanishTime;
            long sessionDuration;
            long startTime;
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || !player.isOnline()) continue;
            dataManager.incrementTotalVanishTime(uuid, 1);
            if (player.hasPermission("vanish.time.bypass") || (startTime = this.vanishStartTime.getOrDefault(uuid, 0L).longValue()) == 0L || (sessionDuration = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime)) < (maxVanishTime = dataManager.getMaxVanishTime())) continue;
            vanishManager.setVanish(player, false);
            player.sendMessage(dataManager.getMessage("messages.max-time-reached", new String[0]));
        }
    }

    public void playerVanished(UUID uuid) {
        this.vanishStartTime.put(uuid, System.currentTimeMillis());
    }

    public void playerUnvanished(UUID uuid) {
        this.vanishStartTime.remove(uuid);
    }
}

