/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyan;

import fr.aeldit.cyan.config.CyanLibConfigImpl;
import java.util.concurrent.ConcurrentHashMap;

public class CombatTracking {
    private static final ConcurrentHashMap<String, Long> lastHurtTime = new ConcurrentHashMap();

    public static void addEntry(String playerName, long hurtTime) {
        lastHurtTime.put(playerName, hurtTime);
    }

    public static boolean isPlayerInCombat(String playerName) {
        if (lastHurtTime.containsKey(playerName)) {
            return System.currentTimeMillis() - lastHurtTime.get(playerName) < (long)(CyanLibConfigImpl.COMBAT_TIMEOUT_SECONDS.getValue() * 1000);
        }
        return false;
    }

    public static void removePlayerOnPlayerQuit(String playerName) {
        lastHurtTime.remove(playerName);
    }
}

