/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyan;

import com.mojang.brigadier.CommandDispatcher;
import fr.aeldit.cyan.CombatTracking;
import fr.aeldit.cyan.CyanCore;
import fr.aeldit.cyan.commands.LocationCommands;
import fr.aeldit.cyan.commands.MiscellaneousCommands;
import fr.aeldit.cyan.commands.PermissionsCommands;
import fr.aeldit.cyan.commands.TeleportationCommands;
import fr.aeldit.cyan.teleportation.BackTps;
import fr.aeldit.cyan.teleportation.TPa;
import fr.aeldit.cyan.util.EventUtils;
import fr.aeldit.cyanlib.lib.commands.CyanLibConfigCommands;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2168;

public class CyanServerCore
implements DedicatedServerModInitializer {
    public void onInitializeServer() {
        CyanCore.LOCATIONS.readServer();
        CyanCore.BACK_TPS.readServer();
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (entity.method_31747()) {
                EventUtils.saveDeadPlayersPos(entity);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (Files.exists(BackTps.BACK_TP_PATH, new LinkOption[0])) {
                CyanCore.BACK_TPS.removeAllOutdated();
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> TPa.removePlayerOnQuit(handler.method_32311().method_5477().getString()));
        ServerLivingEntityEvents.AFTER_DAMAGE.register((entity, source, baseDamageTaken, damageTaken, blocked) -> {
            if (entity.method_31747()) {
                CombatTracking.addEntry(entity.method_5477().getString(), System.currentTimeMillis());
                class_1297 attacker = source.method_5529();
                if (attacker != null) {
                    CombatTracking.addEntry(attacker.method_5477().getString(), System.currentTimeMillis());
                }
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, environment) -> {
            new CyanLibConfigCommands("cyan", CyanCore.CYAN_LIB_UTILS).register(dispatcher);
            TeleportationCommands.register((CommandDispatcher<class_2168>)dispatcher);
            MiscellaneousCommands.register((CommandDispatcher<class_2168>)dispatcher);
            LocationCommands.register((CommandDispatcher<class_2168>)dispatcher);
            PermissionsCommands.register((CommandDispatcher<class_2168>)dispatcher);
        });
        CyanCore.CYAN_LOGGER.info("[Cyan] Successfully initialized");
    }
}

