/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyan.teleportation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public abstract class TPa {
    private static final ConcurrentHashMap<String, List<String>> PLAYERS_TPA_QUEUES = new ConcurrentHashMap();

    public static void addPlayerToQueue(String playerToAdd, String destinationPlayerName) {
        if (!PLAYERS_TPA_QUEUES.containsKey(destinationPlayerName)) {
            PLAYERS_TPA_QUEUES.put(destinationPlayerName, Collections.synchronizedList(new ArrayList()));
        }
        if (!PLAYERS_TPA_QUEUES.get(destinationPlayerName).contains(playerToAdd)) {
            PLAYERS_TPA_QUEUES.get(destinationPlayerName).add(playerToAdd);
        }
    }

    public static void removePlayerFromQueue(String playerToRemove, String destinationPlayerQueue) {
        if (PLAYERS_TPA_QUEUES.containsKey(destinationPlayerQueue)) {
            PLAYERS_TPA_QUEUES.get(destinationPlayerQueue).remove(playerToRemove);
        }
    }

    public static boolean isPlayerRequesting(String requestingPlayerName, String requestedPlayerName) {
        if (PLAYERS_TPA_QUEUES.containsKey(requestedPlayerName)) {
            return PLAYERS_TPA_QUEUES.get(requestedPlayerName).contains(requestingPlayerName);
        }
        return false;
    }

    @Nullable
    public static List<String> getRequestingPlayers(String requestedPlayer) {
        return PLAYERS_TPA_QUEUES.get(requestedPlayer);
    }

    public static void removePlayerOnQuit(String playerName) {
        for (List<String> queue : PLAYERS_TPA_QUEUES.values()) {
            queue.remove(playerName);
        }
    }
}

