/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyan.teleportation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class TPa {
    private final ConcurrentHashMap<String, List<String>> PLAYERS_TPA_QUEUES = new ConcurrentHashMap();
    private final List<String> tpRequests = Collections.synchronizedList(new ArrayList());

    public void requestTp(String playerName) {
        this.tpRequests.add(playerName);
    }

    public boolean playerRequestedTp(String playerName) {
        return this.tpRequests.contains(playerName);
    }

    public synchronized void endTpRequest(String playerName) {
        this.tpRequests.remove(playerName);
    }

    public void addPlayerToQueue(String playerToAdd, String destinationPlayerName) {
        if (!this.PLAYERS_TPA_QUEUES.containsKey(destinationPlayerName)) {
            this.PLAYERS_TPA_QUEUES.put(destinationPlayerName, Collections.synchronizedList(new ArrayList()));
        }
        if (!this.PLAYERS_TPA_QUEUES.get(destinationPlayerName).contains(playerToAdd)) {
            this.PLAYERS_TPA_QUEUES.get(destinationPlayerName).add(playerToAdd);
        }
    }

    public void removePlayerFromQueue(String playerToRemove, String destinationPlayerQueue) {
        if (this.PLAYERS_TPA_QUEUES.containsKey(destinationPlayerQueue)) {
            this.PLAYERS_TPA_QUEUES.get(destinationPlayerQueue).remove(playerToRemove);
        }
    }

    public boolean isPlayerRequesting(String requestingPlayerName, String requestedPlayerName) {
        if (this.PLAYERS_TPA_QUEUES.containsKey(requestedPlayerName)) {
            return this.PLAYERS_TPA_QUEUES.get(requestedPlayerName).contains(requestingPlayerName);
        }
        return false;
    }

    @Nullable
    public List<String> getRequestingPlayers(String requestedPlayer) {
        return this.PLAYERS_TPA_QUEUES.get(requestedPlayer);
    }

    public void removePlayerOnQuit(String playerName) {
        for (List<String> queue : this.PLAYERS_TPA_QUEUES.values()) {
            queue.remove(playerName);
        }
    }
}

