/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyan.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.aeldit.cyan.CyanCore;
import fr.aeldit.cyan.commands.Commons;
import fr.aeldit.cyan.commands.arguments.ArgumentSuggestion;
import fr.aeldit.cyan.config.CyanLibConfigImpl;
import fr.aeldit.cyan.teleportation.Location;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class PermissionsCommands {
    private static final List<String> COMMANDS = List.of("bed", "surface", "location");

    public static void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"cyan").then(class_2170.method_9247((String)"execute").then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(COMMANDS, (SuggestionsBuilder)builder)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).suggests(ArgumentSuggestion::getPlayerTargets).then(class_2170.method_9244((String)"location", (ArgumentType)StringArgumentType.string()).suggests(ArgumentSuggestion::getLocationsIfLoc).executes(PermissionsCommands::executeForTargets))).executes(PermissionsCommands::executeForTargets)))));
    }

    public static int executeForTargets(@NotNull CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 playerSource = ((class_2168)context.getSource()).method_44023();
        if (playerSource != null && !CyanCore.CFG.hasPermission(playerSource, CyanLibConfigImpl.MIN_OP_LVL_PERM_NODES.getValue().intValue())) {
            return 0;
        }
        String command = StringArgumentType.getString(context, (String)"command");
        if (!COMMANDS.contains(command)) {
            return 0;
        }
        Collection players = class_2186.method_9312(context, (String)"targets");
        if (players.isEmpty()) {
            return 0;
        }
        Location location = command.equals("location") ? CyanCore.LOCATIONS.getLocation(StringArgumentType.getString(context, (String)"location")) : null;
        switch (command) {
            case "bed": {
                players.forEach(Commons::bed);
                break;
            }
            case "surface": {
                players.forEach(Commons::surface);
                break;
            }
            case "location": {
                if (location == null) break;
                players.forEach(player -> location.teleport(((class_2168)context.getSource()).method_9211(), (class_3222)player));
            }
        }
        return 1;
    }
}

