/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyan.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.aeldit.cyan.CyanCore;
import fr.aeldit.cyan.TPAsCooldowns;
import fr.aeldit.cyan.commands.Commons;
import fr.aeldit.cyan.commands.arguments.ArgumentSuggestion;
import fr.aeldit.cyan.config.CyanLibConfigImpl;
import fr.aeldit.cyan.teleportation.BackTp;
import fr.aeldit.cyan.util.VersionUtils;
import fr.aeldit.cyanlib.lib.CombatTracking;
import fr.aeldit.cyanlib.lib.config.IntegerOption;
import fr.aeldit.cyanlib.lib.utils.TPUtils;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class TeleportationCommands {
    public static void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"back").executes(TeleportationCommands::back));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"bed").executes(TeleportationCommands::bed));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"b").executes(TeleportationCommands::bed));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"surface").executes(TeleportationCommands::surface));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"s").executes(TeleportationCommands::surface));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpa").then(class_2170.method_9244((String)"player_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getOnlinePlayersName(builder, (class_2168)context.getSource())).executes(TeleportationCommands::tpa)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpaAccept").then(class_2170.method_9244((String)"player_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getRequestingPlayersNames(builder, (class_2168)context.getSource())).executes(TeleportationCommands::acceptTpa)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tpaRefuse").then(class_2170.method_9244((String)"player_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ArgumentSuggestion.getRequestingPlayersNames(builder, (class_2168)context.getSource())).executes(TeleportationCommands::refuseTpa)));
    }

    public static int back(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanCore.CFG.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_BACK_TP.getValue().booleanValue(), "backTpDisabled")) {
            return 0;
        }
        if (!CyanLibConfigImpl.TP_IN_COMBAT.getValue().booleanValue() && CombatTracking.isPlayerInCombat((String)player.method_5477().getString(), (IntegerOption)CyanLibConfigImpl.COMBAT_TIMEOUT_SECONDS)) {
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.noTpWhileInCombat", new Object[0]);
            return 0;
        }
        BackTp backTp = CyanCore.BACK_TPS.getBackTp(player.method_5845());
        MinecraftServer server = VersionUtils.getServer(player);
        if (backTp == null || server == null) {
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.noLastPos", new Object[0]);
            return 0;
        }
        backTp.teleport(server, player);
        CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "msg.backTp", new Object[0]);
        CyanCore.BACK_TPS.remove(player.method_5845());
        return 1;
    }

    public static int bed(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanCore.CFG.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_BED.getValue().booleanValue(), "bedDisabled")) {
            return 0;
        }
        if (!CyanLibConfigImpl.TP_IN_COMBAT.getValue().booleanValue() && CombatTracking.isPlayerInCombat((String)player.method_5477().getString(), (IntegerOption)CyanLibConfigImpl.COMBAT_TIMEOUT_SECONDS)) {
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.noTpWhileInCombat", new Object[0]);
            return 0;
        }
        class_2338 spawnPos = Commons.bed(player);
        if (spawnPos == null) {
            return 0;
        }
        int requiredXpLevel = 0;
        if (CyanLibConfigImpl.USE_XP_TO_TELEPORT.getValue().booleanValue() && !player.method_7337()) {
            requiredXpLevel = CyanLibConfigImpl.XP_USE_FIXED_AMOUNT.getValue() != false ? CyanLibConfigImpl.XP_AMOUNT.getValue() : TPUtils.getRequiredXpLevelsToTp((class_3222)player, (class_2338)spawnPos, (int)CyanLibConfigImpl.BLOCKS_PER_XP_LEVEL_BED.getValue());
            if ((CyanLibConfigImpl.XP_USE_POINTS.getValue() != false ? player.field_7495 : player.field_7520) < requiredXpLevel) {
                CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.notEnoughXp", new Object[]{String.valueOf(class_124.field_1065) + String.valueOf(requiredXpLevel), String.valueOf(class_124.field_1061) + (CyanLibConfigImpl.XP_USE_POINTS.getValue() != false ? "points" : "levels")});
                return 0;
            }
        }
        if (CyanLibConfigImpl.XP_USE_POINTS.getValue().booleanValue()) {
            player.method_7255(-1 * requiredXpLevel);
        } else {
            player.method_7316(-1 * requiredXpLevel);
        }
        return 1;
    }

    public static int surface(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanCore.CFG.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_SURFACE.getValue().booleanValue(), "surfaceDisabled")) {
            return 0;
        }
        if (!CyanLibConfigImpl.TP_IN_COMBAT.getValue().booleanValue() && CombatTracking.isPlayerInCombat((String)player.method_5477().getString(), (IntegerOption)CyanLibConfigImpl.COMBAT_TIMEOUT_SECONDS)) {
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.noTpWhileInCombat", new Object[0]);
            return 0;
        }
        double topY = Commons.surface(player);
        int requiredXpLevel = 0;
        if (CyanLibConfigImpl.USE_XP_TO_TELEPORT.getValue().booleanValue() && !player.method_7337()) {
            int distanceY = (int)player.method_23318() - (int)topY;
            if (distanceY < 0) {
                distanceY *= -1;
            }
            int coordinatesDistance = ++distanceY;
            requiredXpLevel = CyanLibConfigImpl.XP_USE_FIXED_AMOUNT.getValue() != false ? CyanLibConfigImpl.XP_AMOUNT.getValue() : (coordinatesDistance < CyanLibConfigImpl.BLOCKS_PER_XP_LEVEL_SURFACE.getValue() ? 1 : 1 + coordinatesDistance / CyanLibConfigImpl.BLOCKS_PER_XP_LEVEL_SURFACE.getValue());
            if ((CyanLibConfigImpl.XP_USE_POINTS.getValue() != false ? player.field_7495 : player.field_7520) < requiredXpLevel) {
                CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.notEnoughXp", new Object[]{String.valueOf(class_124.field_1065) + String.valueOf(requiredXpLevel), String.valueOf(class_124.field_1061) + (CyanLibConfigImpl.XP_USE_POINTS.getValue() != false ? "points" : "levels")});
                return 0;
            }
        }
        if (CyanLibConfigImpl.XP_USE_POINTS.getValue().booleanValue()) {
            player.method_7255(-1 * requiredXpLevel);
        } else {
            player.method_7316(-1 * requiredXpLevel);
        }
        return 1;
    }

    public static int tpa(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanCore.CFG.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_TPA.getValue().booleanValue(), "tpaDisabled")) {
            return 0;
        }
        if (!CyanLibConfigImpl.TP_IN_COMBAT.getValue().booleanValue() && CombatTracking.isPlayerInCombat((String)player.method_5477().getString(), (IntegerOption)CyanLibConfigImpl.COMBAT_TIMEOUT_SECONDS)) {
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.noTpWhileInCombat", new Object[0]);
            return 0;
        }
        String playerName = StringArgumentType.getString(context, (String)"player_name");
        class_3222 playerToSendMessage = ((class_2168)context.getSource()).method_9211().method_3760().method_14566(playerName);
        if (playerToSendMessage == null) {
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.playerNotFound", new Object[0]);
            return 0;
        }
        String requestingPlayerName = player.method_5477().getString();
        if (CyanCore.TPAS.isPlayerRequesting(requestingPlayerName, playerName)) {
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.tpaAlreadyRequested", new Object[0]);
            return 0;
        }
        CyanCore.TPAS.addPlayerToQueue(requestingPlayerName, playerName);
        CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "msg.tpaRequestSend", new Object[]{requestingPlayerName});
        CyanCore.CYAN_LANG_UTILS.sendPlayerMessageActionBar(playerToSendMessage, "msg.tpaRequested", false, new Object[]{requestingPlayerName});
        playerToSendMessage.method_64398((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1060) + "[Accept]")).method_10862(class_2583.field_24360.method_10958(VersionUtils.getClickEvent("/tpaAccept %s".formatted(requestingPlayerName)))).method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(class_124.field_1061) + "    [Refuse]")).method_10862(class_2583.field_24360.method_10958(VersionUtils.getClickEvent("/tpaRefuse %s".formatted(requestingPlayerName))))));
        return 1;
    }

    public static int acceptTpa(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanCore.CFG.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_TPA.getValue().booleanValue(), "tpaDisabled")) {
            return 0;
        }
        String requestingPlayerName = StringArgumentType.getString(context, (String)"player_name");
        class_3222 requestingPlayer = ((class_2168)context.getSource()).method_9211().method_3760().method_14566(requestingPlayerName);
        if (requestingPlayer == null || !CyanCore.TPAS.isPlayerRequesting(requestingPlayerName, player.method_5477().getString())) {
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.noRequestingPlayers", new Object[0]);
            return 0;
        }
        int requiredXpLevel = 0;
        if (CyanLibConfigImpl.USE_XP_TO_TELEPORT.getValue().booleanValue() && !player.method_7337()) {
            requiredXpLevel = CyanLibConfigImpl.XP_USE_FIXED_AMOUNT.getValue() != false ? CyanLibConfigImpl.XP_AMOUNT.getValue() : TPUtils.getRequiredXpLevelsToTp((class_3222)requestingPlayer, (class_2338)player.method_24515(), (int)CyanLibConfigImpl.BLOCKS_PER_XP_LEVEL_TPA.getValue());
            if ((CyanLibConfigImpl.XP_USE_POINTS.getValue() != false ? player.field_7495 : player.field_7520) < requiredXpLevel) {
                CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(requestingPlayer, "error.notEnoughXpTpa", new Object[]{requestingPlayerName});
                return 0;
            }
        }
        if (CyanLibConfigImpl.TP_COOLDOWN.getValue().booleanValue()) {
            CyanCore.TPAS.requestTp(requestingPlayerName);
            TPAsCooldowns.addPlayerCooldown(requestingPlayer, CyanLibConfigImpl.TP_COOLDOWN_SECONDS.getValue() * 1000, System.currentTimeMillis(), requiredXpLevel, player);
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "msg.waitingXSeconds", new Object[]{String.valueOf(class_124.field_1065) + String.valueOf(CyanLibConfigImpl.TP_COOLDOWN_SECONDS.getValue())});
            return 1;
        }
        VersionUtils.tp(requestingPlayer, player);
        if (CyanLibConfigImpl.XP_USE_POINTS.getValue().booleanValue()) {
            player.method_7255(-1 * requiredXpLevel);
        } else {
            player.method_7316(-1 * requiredXpLevel);
        }
        CyanCore.TPAS.removePlayerFromQueue(requestingPlayerName, player.method_5477().getString());
        CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(requestingPlayer, "msg.tpaSuccessful", new Object[]{player.method_5477().getString()});
        CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "msg.tpaAcceptedSelf", new Object[]{requestingPlayer.method_5477().getString()});
        return 1;
    }

    public static int refuseTpa(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanCore.CFG.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_TPA.getValue().booleanValue(), "tpaDisabled")) {
            return 0;
        }
        String requestingPlayerName = StringArgumentType.getString(context, (String)"player_name");
        class_3222 requestingPlayer = ((class_2168)context.getSource()).method_9211().method_3760().method_14566(requestingPlayerName);
        if (requestingPlayer == null || !CyanCore.TPAS.isPlayerRequesting(requestingPlayerName, player.method_5477().getString())) {
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.noRequestingPlayers", new Object[0]);
            return 0;
        }
        CyanCore.TPAS.removePlayerFromQueue(requestingPlayerName, player.method_5477().getString());
        CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(requestingPlayer, "msg.tpaRefused", new Object[]{player.method_5477().getString()});
        CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "msg.tpaRefusedSelf", new Object[]{requestingPlayer.method_5477().getString()});
        return 1;
    }
}

