/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyan.teleportation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import fr.aeldit.cyan.CyanCore;
import fr.aeldit.cyan.config.CyanLibConfigImpl;
import fr.aeldit.cyan.teleportation.BackTp;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackTps {
    private final List<BackTp> backTps = Collections.synchronizedList(new ArrayList());
    private final TypeToken<List<BackTp>> backTpType = new TypeToken<List<BackTp>>(this){};
    public static Path BACK_TP_PATH = FabricLoader.getInstance().getConfigDir().resolve(Path.of("%s/back.json".formatted("cyan"), new String[0]));

    public void add(@NotNull BackTp backTp) {
        this.backTps.remove(backTp);
        this.backTps.add(backTp);
        this.write();
    }

    public void remove(String playerUUID) {
        BackTp backTp = this.getBackTp(playerUUID);
        if (backTp != null) {
            this.backTps.remove(backTp);
            this.write();
        }
    }

    public void removeAllOutdated() {
        try {
            ArrayList<BackTp> tmp = new ArrayList<BackTp>();
            int maxTime = CyanLibConfigImpl.DAYS_TO_REMOVE_BACK_TP.getValue();
            for (BackTp backTp : this.backTps) {
                long days = TimeUnit.DAYS.convert(Math.abs(new Date().getTime() - new SimpleDateFormat("dd/MM/yyyy").parse(backTp.date()).getTime()), TimeUnit.MILLISECONDS);
                if (days < (long)maxTime) continue;
                tmp.add(backTp);
            }
            this.backTps.removeAll(tmp);
            this.write();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public BackTp getBackTp(String playerUUID) {
        return this.backTps.stream().filter(backTp -> backTp.playerUUID().equals(playerUUID)).findFirst().orElse(null);
    }

    public boolean backTpExists(String playerUUID) {
        return this.backTps.stream().anyMatch(backTp -> backTp.playerUUID().equals(playerUUID));
    }

    public void readServer() {
        if (Files.exists(BACK_TP_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(BACK_TP_PATH);){
                this.backTps.addAll((Collection)new Gson().fromJson((Reader)reader, this.backTpType));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void readClient(String saveName) {
        BACK_TP_PATH = FabricLoader.getInstance().getConfigDir().resolve(Path.of("%s/%s/back.json".formatted("cyan", saveName), new String[0]));
        if (Files.exists(BACK_TP_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(BACK_TP_PATH);){
                this.backTps.addAll((Collection)new Gson().fromJson((Reader)reader, this.backTpType));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void write() {
        CyanCore.checkOrCreateModDir(false);
        if (this.backTps.isEmpty()) {
            if (Files.exists(BACK_TP_PATH, new LinkOption[0])) {
                try {
                    Files.delete(BACK_TP_PATH);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                CyanCore.removeEmptyModDir(false);
            }
        } else {
            try (BufferedWriter writer = Files.newBufferedWriter(BACK_TP_PATH, new OpenOption[0]);){
                new GsonBuilder().create().toJson(this.backTps, (Appendable)writer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

