/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyan.teleportation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.aeldit.cyan.CyanCore;
import fr.aeldit.cyan.teleportation.Location;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2172;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Locations {
    private final List<Location> locations = Collections.synchronizedList(new ArrayList());
    private final TypeToken<List<Location>> locationsType = new TypeToken<List<Location>>(this){};
    public static Path LOCATIONS_PATH = FabricLoader.getInstance().getConfigDir().resolve(Path.of("%s/locations.json".formatted("cyan"), new String[0]));
    private final List<String> tpRequests = Collections.synchronizedList(new ArrayList());

    public void requestTp(String playerName) {
        this.tpRequests.add(playerName);
    }

    public boolean playerRequestedTp(String playerName) {
        return this.tpRequests.contains(playerName);
    }

    public synchronized void endTpRequest(String playerName) {
        this.tpRequests.remove(playerName);
    }

    public boolean add(@NotNull Location location) {
        if (this.getLocation(location.name()) == null) {
            this.locations.add(location);
            this.write();
            return true;
        }
        return false;
    }

    public boolean remove(String locationName) {
        Location location = this.getLocation(locationName);
        if (location != null) {
            this.locations.remove(location);
            this.write();
            return true;
        }
        return false;
    }

    public boolean removeAll() {
        if (!this.locations.isEmpty()) {
            this.locations.clear();
            this.write();
            return true;
        }
        return false;
    }

    public boolean rename(String locationName, String newLocationName) {
        Location location = this.getLocation(locationName);
        if (location != null) {
            this.locations.remove(location);
            this.locations.add(location.getRenamed(newLocationName));
            this.write();
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.locations.isEmpty();
    }

    @Nullable
    public List<Location> getLocations() {
        return this.locations;
    }

    public CompletableFuture<Suggestions> getLocationsNames(@NotNull SuggestionsBuilder builder) {
        return class_2172.method_9265(this.locations.stream().map(Location::name).toList(), (SuggestionsBuilder)builder);
    }

    @Nullable
    public Location getLocation(String locationName) {
        return this.locations.stream().filter(location -> location.name().equals(locationName)).findFirst().orElse(null);
    }

    public void readServer() {
        if (Files.exists(LOCATIONS_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(LOCATIONS_PATH);){
                this.locations.addAll((Collection)new Gson().fromJson((Reader)reader, this.locationsType));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void readClient(String saveName) {
        LOCATIONS_PATH = FabricLoader.getInstance().getConfigDir().resolve(Path.of("%s/%s/locations.json".formatted("cyan", saveName), new String[0]));
        if (Files.exists(LOCATIONS_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(LOCATIONS_PATH);){
                this.locations.addAll((Collection)new Gson().fromJson((Reader)reader, this.locationsType));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void write() {
        CyanCore.checkOrCreateModDir(true);
        if (this.locations.isEmpty()) {
            if (Files.exists(LOCATIONS_PATH, new LinkOption[0])) {
                try {
                    Files.delete(LOCATIONS_PATH);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                CyanCore.removeEmptyModDir(true);
            }
        } else {
            try (BufferedWriter writer = Files.newBufferedWriter(LOCATIONS_PATH, new OpenOption[0]);){
                new GsonBuilder().setPrettyPrinting().create().toJson(this.locations, (Appendable)writer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

