/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyan;

import com.mojang.brigadier.CommandDispatcher;
import fr.aeldit.cyan.LocationsCooldowns;
import fr.aeldit.cyan.TPAsCooldowns;
import fr.aeldit.cyan.commands.LocationCommands;
import fr.aeldit.cyan.commands.MiscellaneousCommands;
import fr.aeldit.cyan.commands.PermissionsCommands;
import fr.aeldit.cyan.commands.TeleportationCommands;
import fr.aeldit.cyan.config.CyanLibConfigImpl;
import fr.aeldit.cyan.teleportation.BackTps;
import fr.aeldit.cyan.teleportation.Locations;
import fr.aeldit.cyan.teleportation.TPa;
import fr.aeldit.cyan.util.EventUtils;
import fr.aeldit.cyan.util.VersionUtils;
import fr.aeldit.cyanlib.events.MissingLivingEntityEvent;
import fr.aeldit.cyanlib.events.PlayerMovedEvent;
import fr.aeldit.cyanlib.lib.CombatTracking;
import fr.aeldit.cyanlib.lib.CyanLib;
import fr.aeldit.cyanlib.lib.CyanLibLanguageUtils;
import fr.aeldit.cyanlib.lib.commands.CyanLibConfigCommands;
import fr.aeldit.cyanlib.lib.config.ICyanLibConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyanCore
implements ModInitializer {
    public static final String MOD_ID = "cyan";
    public static final Logger CYAN_LOGGER = LoggerFactory.getLogger((String)"cyan");
    public static final Locations LOCATIONS = new Locations();
    public static final BackTps BACK_TPS = new BackTps();
    public static final TPa TPAS = new TPa();
    public static final CyanLib CFG = new CyanLib("cyan", (ICyanLibConfig)new CyanLibConfigImpl());
    public static final CyanLibLanguageUtils CYAN_LANG_UTILS = CFG.getLanguageUtils();

    public static void checkOrCreateModDir(boolean locations) {
        Path dir = FabricLoader.getInstance().getConfigDir().resolve(MOD_ID);
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!Files.exists(dir = locations ? Path.of(Locations.LOCATIONS_PATH.toString().replace("locations.json", ""), new String[0]) : Path.of(BackTps.BACK_TP_PATH.toString().replace("back.json", ""), new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void removeEmptyModDir(boolean locations) {
        File[] listOfFiles;
        Path dir = locations ? Path.of(Locations.LOCATIONS_PATH.toString().replace("locations.json", ""), new String[0]) : Path.of(BackTps.BACK_TP_PATH.toString().replace("back.json", ""), new String[0]);
        if (Files.exists(dir, new LinkOption[0]) && Objects.requireNonNull(listOfFiles = new File(dir.toUri()).listFiles()).length == 0) {
            try {
                Files.delete(dir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (Files.exists(dir = FabricLoader.getInstance().getConfigDir().resolve(MOD_ID), new LinkOption[0]) && Objects.requireNonNull(listOfFiles = new File(dir.toUri()).listFiles()).length == 0) {
            try {
                Files.delete(dir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void onInitialize() {
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (entity.method_31747()) {
                EventUtils.saveDeadPlayersPos(entity);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (Files.exists(BackTps.BACK_TP_PATH, new LinkOption[0])) {
                BACK_TPS.removeAllOutdated();
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> TPAS.removePlayerOnQuit(handler.method_32311().method_5477().getString()));
        PlayerMovedEvent.AFTER_MOVE.register(player -> {
            if (LOCATIONS.playerRequestedTp(player.method_5477().getString())) {
                LocationsCooldowns.cancelCooldown(player);
                LOCATIONS.endTpRequest(player.method_5477().getString());
            }
            if (TPAS.playerRequestedTp(player.method_5477().getString())) {
                TPAsCooldowns.cancelCooldown(player);
                TPAS.endTpRequest(player.method_5477().getString());
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(minecraftServer -> {
            LocationsCooldowns.getCanceledCooldowns().forEach(player -> CYAN_LANG_UTILS.sendPlayerMessage(player, "error.movedWhileWaitingForTp", new Object[0]));
            LocationsCooldowns.clearCanceledCooldowns();
            LocationsCooldowns.getPlayersCompletedCooldowns().forEach((player, t) -> {
                LOCATIONS.endTpRequest(player.method_5477().getString());
                t.loc().teleport(t.server(), (class_3222)player);
                if (CyanLibConfigImpl.XP_USE_POINTS.getValue().booleanValue()) {
                    player.method_7255(-1 * t.requiredXpLevel());
                } else {
                    player.method_7316(-1 * t.requiredXpLevel());
                }
                CYAN_LANG_UTILS.sendPlayerMessage(player, "msg.goToLocation", new Object[]{String.valueOf(class_124.field_1054) + t.loc().name()});
            });
            TPAsCooldowns.getCanceledCooldowns().forEach(player -> CYAN_LANG_UTILS.sendPlayerMessage(player, "error.movedWhileWaitingForTp", new Object[0]));
            TPAsCooldowns.clearCanceledCooldowns();
            TPAsCooldowns.getPlayersCompletedCooldowns().forEach((requestingPlayer, t) -> {
                TPAS.endTpRequest(requestingPlayer.method_5477().getString());
                VersionUtils.tp(requestingPlayer, t.requestedPlayer());
                if (CyanLibConfigImpl.XP_USE_POINTS.getValue().booleanValue()) {
                    requestingPlayer.method_7255(-1 * t.requiredXpLevel());
                } else {
                    requestingPlayer.method_7316(-1 * t.requiredXpLevel());
                }
                TPAS.removePlayerFromQueue(requestingPlayer.method_5477().getString(), t.requestedPlayer().method_5477().getString());
                CYAN_LANG_UTILS.sendPlayerMessage(requestingPlayer, "msg.tpaSuccessful", new Object[]{t.requestedPlayer().method_5477().getString()});
                CYAN_LANG_UTILS.sendPlayerMessage(t.requestedPlayer(), "msg.tpaAcceptedSelf", new Object[]{requestingPlayer.method_5477().getString()});
            });
        });
        MissingLivingEntityEvent.AFTER_DAMAGE.register((entity, source, amount) -> {
            if (entity.method_31747()) {
                CombatTracking.addEntry((String)entity.method_5477().getString(), (long)System.currentTimeMillis());
                class_1297 attacker = source.method_5529();
                if (attacker != null) {
                    CombatTracking.addEntry((String)attacker.method_5477().getString(), (long)System.currentTimeMillis());
                }
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, environment) -> {
            new CyanLibConfigCommands(MOD_ID, CFG).register(dispatcher);
            TeleportationCommands.register((CommandDispatcher<class_2168>)dispatcher);
            MiscellaneousCommands.register((CommandDispatcher<class_2168>)dispatcher);
            LocationCommands.register((CommandDispatcher<class_2168>)dispatcher);
            PermissionsCommands.register((CommandDispatcher<class_2168>)dispatcher);
        });
        CYAN_LOGGER.info("[Cyan] Successfully initialized");
    }
}

