/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyan;

import fr.aeldit.cyan.teleportation.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class LocationsCooldowns {
    private static final ConcurrentHashMap<class_3222, Tuple> playersCooldowns = new ConcurrentHashMap();
    private static final List<class_3222> canceledCooldowns = Collections.synchronizedList(new ArrayList());

    public static void cancelCooldown(class_3222 player) {
        canceledCooldowns.add(player);
        playersCooldowns.remove(player);
    }

    public static List<class_3222> getCanceledCooldowns() {
        return canceledCooldowns;
    }

    public static void clearCanceledCooldowns() {
        canceledCooldowns.clear();
    }

    public static void addPlayerCooldown(class_3222 player, long cooldown, long startTime, Location loc, int requiredXpLevel, MinecraftServer server) {
        playersCooldowns.put(player, new Tuple(cooldown, startTime, loc, requiredXpLevel, server));
    }

    @NotNull
    public static HashMap<class_3222, Tuple> getPlayersCompletedCooldowns() {
        long currentTime = System.currentTimeMillis();
        HashMap<class_3222, Tuple> completedCooldowns = new HashMap<class_3222, Tuple>();
        for (Map.Entry<class_3222, Tuple> entry : playersCooldowns.entrySet()) {
            if (currentTime - entry.getValue().startTime() <= entry.getValue().cooldown()) continue;
            completedCooldowns.put(entry.getKey(), entry.getValue());
        }
        completedCooldowns.forEach(playersCooldowns::remove);
        return completedCooldowns;
    }

    public record Tuple(long cooldown, long startTime, Location loc, int requiredXpLevel, MinecraftServer server) {
    }
}

