/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.cyan.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.aeldit.cyan.CyanCore;
import fr.aeldit.cyan.LocationsCooldowns;
import fr.aeldit.cyan.config.CyanLibConfigImpl;
import fr.aeldit.cyan.teleportation.Location;
import fr.aeldit.cyan.util.VersionUtils;
import fr.aeldit.cyanlib.lib.CombatTracking;
import fr.aeldit.cyanlib.lib.config.IntegerOption;
import fr.aeldit.cyanlib.lib.utils.TPUtils;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class LocationCommands {
    public static void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"set-location").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(LocationCommands::setLocation)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"sl").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(LocationCommands::setLocation)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"remove-location").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CyanCore.LOCATIONS.getLocationsNames(builder)).executes(LocationCommands::removeLocation)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"rl").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CyanCore.LOCATIONS.getLocationsNames(builder)).executes(LocationCommands::removeLocation)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"remove-all-locations").executes(LocationCommands::removeAllLocations));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"rename-location").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CyanCore.LOCATIONS.getLocationsNames(builder)).then(class_2170.method_9244((String)"new_name", (ArgumentType)StringArgumentType.string()).executes(LocationCommands::renameLocation))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"location").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CyanCore.LOCATIONS.getLocationsNames(builder)).executes(LocationCommands::goToLocation))).executes(LocationCommands::getLocationsList));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"l").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CyanCore.LOCATIONS.getLocationsNames(builder)).executes(LocationCommands::goToLocation))).executes(LocationCommands::getLocationsList));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"get-locations").executes(LocationCommands::getLocationsList));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"gl").executes(LocationCommands::getLocationsList));
    }

    public static int setLocation(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanCore.CFG.hasPermission(player, CyanLibConfigImpl.MIN_OP_LVL_EDIT_LOCATIONS.getValue().intValue()) || !CyanCore.CFG.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_LOCATIONS.getValue().booleanValue(), "locationsDisabled")) {
            return 0;
        }
        String locationName = StringArgumentType.getString(context, (String)"name");
        if (!CyanCore.LOCATIONS.add(new Location(locationName, VersionUtils.getWorld((class_1309)player).method_44013().method_29177().toString().replace("minecraft:", "").replace("the_", ""), player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455()))) {
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.locationAlreadyExists", new Object[0]);
            return 0;
        }
        CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "msg.setLocation", new Object[]{String.valueOf(class_124.field_1054) + locationName});
        return 1;
    }

    public static int removeLocation(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanCore.CFG.hasPermission(player, CyanLibConfigImpl.MIN_OP_LVL_EDIT_LOCATIONS.getValue().intValue()) || !CyanCore.CFG.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_LOCATIONS.getValue().booleanValue(), "locationsDisabled")) {
            return 0;
        }
        String locationName = StringArgumentType.getString(context, (String)"name");
        if (!CyanCore.LOCATIONS.remove(locationName)) {
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.locationNotFound", new Object[]{String.valueOf(class_124.field_1054) + locationName});
            return 0;
        }
        CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "msg.removeLocation", new Object[]{String.valueOf(class_124.field_1054) + locationName});
        return 1;
    }

    public static int removeAllLocations(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanCore.CFG.hasPermission(player, CyanLibConfigImpl.MIN_OP_LVL_EDIT_LOCATIONS.getValue().intValue()) || !CyanCore.CFG.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_LOCATIONS.getValue().booleanValue(), "locationsDisabled")) {
            return 0;
        }
        if (!CyanCore.LOCATIONS.removeAll()) {
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.noLocations", new Object[0]);
            return 0;
        }
        CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "msg.removedAllLocations", new Object[0]);
        return 1;
    }

    public static int renameLocation(@NotNull CommandContext<class_2168> context) {
        String newLocationName;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanCore.CFG.hasPermission(player, CyanLibConfigImpl.MIN_OP_LVL_EDIT_LOCATIONS.getValue().intValue()) || !CyanCore.CFG.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_LOCATIONS.getValue().booleanValue(), "locationsDisabled")) {
            return 0;
        }
        String locationName = StringArgumentType.getString(context, (String)"name");
        if (!CyanCore.LOCATIONS.rename(locationName, newLocationName = StringArgumentType.getString(context, (String)"new_name"))) {
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.locationNotFound", new Object[]{locationName});
            return 0;
        }
        CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "msg.renameLocation", new Object[]{String.valueOf(class_124.field_1054) + locationName, String.valueOf(class_124.field_1054) + newLocationName});
        return 1;
    }

    public static int goToLocation(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanCore.CFG.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_LOCATIONS.getValue().booleanValue(), "locationsDisabled")) {
            return 0;
        }
        if (!CyanLibConfigImpl.TP_IN_COMBAT.getValue().booleanValue() && CombatTracking.isPlayerInCombat((String)player.method_5477().getString(), (IntegerOption)CyanLibConfigImpl.COMBAT_TIMEOUT_SECONDS)) {
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.noTpWhileInCombat", new Object[0]);
            return 0;
        }
        String locationName = StringArgumentType.getString(context, (String)"name");
        Location loc = CyanCore.LOCATIONS.getLocation(locationName);
        MinecraftServer server = VersionUtils.getServer(player);
        if (loc == null || server == null) {
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.locationNotFound", new Object[]{String.valueOf(class_124.field_1054) + locationName});
            return 0;
        }
        int requiredXpLevel = 0;
        if (CyanLibConfigImpl.USE_XP_TO_TELEPORT.getValue().booleanValue() && !player.method_7337()) {
            requiredXpLevel = CyanLibConfigImpl.XP_USE_FIXED_AMOUNT.getValue() != false ? CyanLibConfigImpl.XP_AMOUNT.getValue() : TPUtils.getRequiredXpLevelsToTp((class_3222)player, (class_2338)new class_2338((int)loc.x(), (int)loc.y(), (int)loc.z()), (int)CyanLibConfigImpl.BLOCKS_PER_XP_LEVEL_LOCATION.getValue());
            if ((CyanLibConfigImpl.XP_USE_POINTS.getValue() != false ? player.field_7495 : player.field_7520) < requiredXpLevel) {
                CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.notEnoughXp", new Object[]{String.valueOf(class_124.field_1065) + String.valueOf(requiredXpLevel), String.valueOf(class_124.field_1061) + (CyanLibConfigImpl.XP_USE_POINTS.getValue() != false ? "points" : "levels")});
                return 0;
            }
        }
        if (CyanLibConfigImpl.TP_COOLDOWN.getValue().booleanValue()) {
            String playerName = player.method_5477().getString();
            CyanCore.LOCATIONS.requestTp(playerName);
            LocationsCooldowns.addPlayerCooldown(player, CyanLibConfigImpl.TP_COOLDOWN_SECONDS.getValue() * 1000, System.currentTimeMillis(), loc, requiredXpLevel, server);
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "msg.waitingXSeconds", new Object[]{String.valueOf(class_124.field_1065) + String.valueOf(CyanLibConfigImpl.TP_COOLDOWN_SECONDS.getValue())});
            return 1;
        }
        loc.teleport(server, player);
        if (CyanLibConfigImpl.XP_USE_POINTS.getValue().booleanValue()) {
            player.method_7255(-1 * requiredXpLevel);
        } else {
            player.method_7316(-1 * requiredXpLevel);
        }
        CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "msg.goToLocation", new Object[]{String.valueOf(class_124.field_1054) + locationName});
        return 1;
    }

    public static int getLocationsList(@NotNull CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null || !CyanCore.CFG.isOptionEnabled(player, CyanLibConfigImpl.ALLOW_LOCATIONS.getValue().booleanValue(), "locationsDisabled")) {
            return 0;
        }
        if (CyanCore.LOCATIONS.isEmpty()) {
            CyanCore.CYAN_LANG_UTILS.sendPlayerMessage(player, "error.noLocations", new Object[0]);
            return 0;
        }
        player.method_7353(class_2561.method_30163((String)"\u00a76------------------------------------"), false);
        CyanCore.CYAN_LANG_UTILS.sendPlayerMessageActionBar(player, "msg.listLocations", false, new Object[0]);
        List<Location> locations = CyanCore.LOCATIONS.getLocations();
        if (locations != null) {
            for (Location location : locations) {
                CyanCore.CYAN_LANG_UTILS.sendPlayerMessageActionBar(player, "msg.getLocation", false, new Object[]{String.valueOf(class_124.field_1054) + location.name(), String.valueOf(class_124.field_1062) + location.dimension()});
            }
        }
        player.method_7353(class_2561.method_30163((String)"\u00a76------------------------------------"), false);
        return 1;
    }
}

