/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.multipart.api.RedstoneInteractions;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.redstone.RedstonePart;
import mrtjp.projectred.core.CenterLookup;
import mrtjp.projectred.core.part.IRedwireEmitter;
import mrtjp.projectred.core.part.IRedwirePart;

public class RedstoneCenterLookup {
    public static int resolveSignal(CenterLookup lookup, boolean diminishRedwire) {
        MultiPart multiPart = lookup.part;
        if (multiPart instanceof IRedwirePart) {
            IRedwirePart rw = (IRedwirePart)multiPart;
            int signal = rw.getRedwireSignal(lookup.otherDirection);
            if (diminishRedwire && rw.diminishOnSide(lookup.otherDirection)) {
                --signal;
            }
            return Math.max(0, signal);
        }
        multiPart = lookup.part;
        if (multiPart instanceof IRedwireEmitter) {
            IRedwireEmitter rwe = (IRedwireEmitter)multiPart;
            return rwe.getRedwireSignal(lookup.otherDirection);
        }
        multiPart = lookup.part;
        if (multiPart instanceof RedstonePart) {
            RedstonePart rw = (RedstonePart)multiPart;
            return Math.max(rw.strongPowerLevel(lookup.otherDirection), rw.weakPowerLevel(lookup.otherDirection));
        }
        return 0;
    }

    public static int resolveVanillaSignal(CenterLookup lookup, MultiPart part) {
        return RedstoneInteractions.getPowerTo((MultiPart)part, (int)lookup.direction) * 17;
    }
}

