/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.client.particle;

import mrtjp.projectred.core.client.particle.BaseActionParticle;
import mrtjp.projectred.core.client.particle.ParticleAction;

public class GroupAction
extends ParticleAction {
    private final ParticleAction[] actions;

    public GroupAction(ParticleAction ... actions) {
        this.actions = actions;
    }

    @Override
    public void tick() {
        super.tick();
        for (ParticleAction action : this.actions) {
            action.tick();
        }
    }

    @Override
    public void operate(BaseActionParticle particle, float partialTick) {
        super.operate(particle, partialTick);
        boolean allFinished = true;
        for (ParticleAction action : this.actions) {
            action.operate(particle, partialTick);
            if (action.isFinished()) continue;
            allFinished = false;
        }
        this.finished = allFinished;
    }

    @Override
    public ParticleAction copy() {
        ParticleAction[] newActions = new ParticleAction[this.actions.length];
        for (int i = 0; i < this.actions.length; ++i) {
            newActions[i] = this.actions[i].copy();
        }
        return new GroupAction(newActions);
    }

    @Override
    public void beginAction(BaseActionParticle particle) {
        for (ParticleAction action : this.actions) {
            action.beginAction(particle);
        }
    }

    @Override
    public void operateAction(BaseActionParticle particle, double time) {
    }
}

