/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.data;

import javax.annotation.Nonnull;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.core.init.CoreBlocks;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class CoreBlockStateModelProvider
extends BlockStateProvider {
    public CoreBlockStateModelProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "projectred_core", exFileHelper);
    }

    @Nonnull
    public String getName() {
        return "ProjectRed-Core Block State Models";
    }

    protected void registerStatesAndModels() {
        this.quadStateFrontFacedPoweredMachineModel(CoreBlocks.ELECTROTINE_GENERATOR_BLOCK.get());
    }

    private void quadStateFrontFacedPoweredMachineModel(Block block) {
        this.addRotatablePoweredMachineVariants(block, (ModelFile)this.createFrontFacedPoweredMachineModel(block, 0), (ModelFile)this.createFrontFacedPoweredMachineModel(block, 1), (ModelFile)this.createFrontFacedPoweredMachineModel(block, 2), (ModelFile)this.createFrontFacedPoweredMachineModel(block, 3));
    }

    private void addRotatablePoweredMachineVariants(Block block, ModelFile idleModel, ModelFile chargedModel, ModelFile workingModel, ModelFile chargedWorkingModel) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int r = (Integer)state.getValue((Property)ProjectRedBlock.ROTATION);
            boolean isWorking = (Boolean)state.getValue((Property)ProjectRedBlock.WORKING);
            boolean isCharged = (Boolean)state.getValue((Property)ProjectRedBlock.CHARGED);
            ModelFile modelFile = !isWorking && !isCharged ? idleModel : (isWorking && !isCharged ? workingModel : (!isWorking && isCharged ? chargedModel : chargedWorkingModel));
            return ConfiguredModel.builder().modelFile(modelFile).rotationY(r * 90).build();
        });
    }

    private BlockModelBuilder createFrontFacedPoweredMachineModel(Block block, int state) {
        String texture = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        String modelName = texture + (String)(state > 0 ? "_state" + state : "");
        return (BlockModelBuilder)this.models().orientableWithBottom(modelName, this.modLoc("block/" + texture + "_side"), this.modLoc("block/" + texture + "_front_" + state), this.modLoc("block/" + texture + "_bottom"), this.modLoc("block/" + texture + "_top"));
    }
}

