/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.lib;

public class Vec2 {
    public static final Vec2 ZERO = new Vec2(0.0, 0.0);
    public final double dx;
    public final double dy;

    public Vec2(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public Vec2 add(Vec2 other) {
        return new Vec2(this.dx + other.dx, this.dy + other.dy);
    }

    public Vec2 subtract(Vec2 other) {
        return new Vec2(this.dx - other.dx, this.dy - other.dy);
    }

    public Vec2 multiply(Vec2 other) {
        return new Vec2(this.dx * other.dx, this.dy * other.dy);
    }

    public Vec2 divide(Vec2 other) {
        return new Vec2(this.dx / other.dx, this.dy / other.dy);
    }

    public Vec2 add(double dx, double dy) {
        return new Vec2(this.dx + dx, this.dy + dy);
    }

    public Vec2 subtract(double dx, double dy) {
        return new Vec2(this.dx - dx, this.dy - dy);
    }

    public Vec2 multiply(double dx, double dy) {
        return new Vec2(this.dx * dx, this.dy * dy);
    }

    public Vec2 divide(double dx, double dy) {
        return new Vec2(this.dx / dx, this.dy / dy);
    }

    public Vec2 add(double d) {
        return this.add(d, d);
    }

    public Vec2 subtract(double d) {
        return this.subtract(d, d);
    }

    public Vec2 multiply(double d) {
        return this.multiply(d, d);
    }

    public Vec2 divide(double d) {
        return this.divide(d, d);
    }

    public double dot(Vec2 other) {
        return this.dx * other.dx + this.dy * other.dy;
    }

    public double dot(double dx, double dy) {
        return this.dx * dx + this.dy * dy;
    }

    public double mag() {
        return Math.sqrt(this.dx * this.dx + this.dy * this.dy);
    }

    public double magSquared() {
        return this.dx * this.dx + this.dy * this.dy;
    }

    public Vec2 normalize() {
        double mag = this.mag();
        return mag == 0.0 ? ZERO : new Vec2(this.dx / mag, this.dy / mag);
    }

    public Vec2 negate() {
        return new Vec2(-this.dx, -this.dy);
    }

    public Vec2 flip() {
        return new Vec2(this.dy, this.dx);
    }

    public Vec2 project(Vec2 other) {
        double d = this.dot(other) / other.magSquared();
        return other.multiply(d, d);
    }

    public Vec2 reject(Vec2 other) {
        return this.subtract(this.project(other));
    }

    public Vec2 axialProject() {
        if (Math.abs(this.dx) > Math.abs(this.dy)) {
            return new Vec2(this.dx, 0.0);
        }
        return new Vec2(0.0, this.dy);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vec2) {
            Vec2 other = (Vec2)obj;
            return this.dx == other.dx && this.dy == other.dy;
        }
        return false;
    }

    public String toString() {
        return "Vec2[" + this.dx + ", " + this.dy + "]";
    }
}

