/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.redui;

import java.util.List;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.AbstractGuiNode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemStackNode
extends AbstractGuiNode {
    private ItemStack itemStack;

    public ItemStackNode(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.setSize(16, 16);
    }

    public ItemStackNode() {
        this(ItemStack.EMPTY);
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public void drawBack(GuiGraphics graphics, Point mouse, float partialFrame) {
        graphics.renderItem(this.itemStack, this.getPosition().x, this.getPosition().y);
        if (this.isFirstHit(mouse)) {
            AbstractContainerScreen.renderSlotHighlight((GuiGraphics)graphics, (int)this.getPosition().x, (int)this.getPosition().y, (int)0);
        }
    }

    @Override
    public void drawFront(GuiGraphics graphics, Point mouse, float partialFrame) {
        if (this.isFirstHit(mouse)) {
            Minecraft minecraft = this.getRoot().getMinecraft();
            List tooltip = this.itemStack.getTooltipLines(Item.TooltipContext.of((Level)this.getRoot().getMinecraft().level), (Player)minecraft.player, (TooltipFlag)(minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
            this.renderTooltip(graphics, mouse, tooltip);
        }
    }
}

