/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.redui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Rect;
import mrtjp.projectred.lib.Size;
import mrtjp.projectred.redui.RedUINode;
import mrtjp.projectred.redui.RedUIRootNode;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class RedUIScreen
extends Screen
implements RedUIRootNode {
    private final List<RedUINode> children = new LinkedList<RedUINode>();
    private Rect frame;
    private Rect screenFrame;
    private double zPos = 0.0;
    private long lastClickTime = 0L;

    public RedUIScreen(int backgroundWidth, int backgroundHeight, Component title) {
        super(title);
        this.frame = new Rect(Point.ZERO, new Size(backgroundWidth, backgroundHeight));
        this.screenFrame = Rect.ZERO;
        this.onAddedToParent();
    }

    protected void init() {
        super.init();
        this.screenFrame = new Rect(Point.ZERO, new Size(this.width, this.height));
        Point framePos = new Point((this.screenFrame.width() - this.frame.width()) / 2, (this.screenFrame.height() - this.frame.height()) / 2);
        this.frame = new Rect(framePos, this.frame.size);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialFrame) {
        super.render(graphics, mouseX, mouseY, partialFrame);
        RenderSystem.enableDepthTest();
        int x = this.getScreenFrame().x();
        int y = this.getScreenFrame().y();
        graphics.fillGradient(x, y, x + this.getScreenFrame().width(), y + this.getScreenFrame().height(), -1072689136, -804253680);
        Point mousePoint = new Point(mouseX, mouseY);
        this.operateOnSubtree(mousePoint, (n, p, c) -> {
            n.frameUpdate(p, partialFrame);
            return false;
        }, false);
        this.drawBackForSubtree(graphics, mousePoint, partialFrame);
        this.drawFrontForSubtree(graphics, mousePoint, partialFrame);
    }

    public void tick() {
        super.tick();
        this.getSubTree(n -> true).forEach(RedUINode::update);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double x, double y, int glfwMouseButton) {
        this.lastClickTime = System.currentTimeMillis();
        boolean consumed = super.mouseClicked(x, y, glfwMouseButton);
        return this.operateOnZOrderedSubtree(new Point((int)x, (int)y), (n, p, c) -> n.mouseClicked(p, glfwMouseButton, c), consumed);
    }

    public boolean mouseReleased(double x, double y, int button) {
        boolean consumed = super.mouseReleased(x, y, button);
        long timeSinceLastClick = System.currentTimeMillis() - this.lastClickTime;
        return this.operateOnZOrderedSubtree(new Point((int)x, (int)y), (n, p, c) -> n.mouseReleased(p, button, timeSinceLastClick, c), consumed);
    }

    public boolean mouseDragged(double x, double y, int button, double dragX, double dragY) {
        boolean consumed = super.mouseDragged(x, y, button, dragX, dragY);
        long timeSinceLastClick = System.currentTimeMillis() - this.lastClickTime;
        return this.operateOnZOrderedSubtree(new Point((int)x, (int)y), (n, p, c) -> n.mouseDragged(p, button, timeSinceLastClick, c), consumed);
    }

    public boolean mouseScrolled(double x, double y, double scrollX, double scrollY) {
        boolean consumed = super.mouseScrolled(x, y, scrollX, scrollY);
        return this.operateOnZOrderedSubtree(new Point((int)x, (int)y), (n, p, c) -> n.mouseScrolled(p, scrollX, scrollY, c), consumed);
    }

    public boolean charTyped(char keyPressed, int glfwFlags) {
        boolean consumed = super.charTyped(keyPressed, glfwFlags);
        return this.operateOnZOrderedSubtree(Point.ZERO, (n, p, c) -> n.onCharTyped(keyPressed, glfwFlags, c), consumed);
    }

    public boolean keyPressed(int glfwKeyCode, int glfwScanCode, int glfwFlags) {
        boolean consumed = super.keyPressed(glfwKeyCode, glfwScanCode, glfwFlags);
        return this.operateOnZOrderedSubtree(Point.ZERO, (n, p, c) -> n.onKeyPressed(glfwKeyCode, glfwScanCode, glfwFlags, c), consumed);
    }

    public boolean keyReleased(int glfwKeyCode, int glfwScanCode, int glfwFlags) {
        boolean consumed = super.keyReleased(glfwKeyCode, glfwScanCode, glfwFlags);
        return this.operateOnZOrderedSubtree(Point.ZERO, (n, p, c) -> n.onKeyReleased(glfwKeyCode, glfwScanCode, glfwFlags, c), consumed);
    }

    @Override
    public Rect getScreenFrame() {
        return this.screenFrame;
    }

    @Override
    public List<RedUINode> getOurChildren() {
        return this.children;
    }

    @Override
    public Rect getFrame() {
        return this.frame;
    }

    @Override
    public Point getPosition() {
        return this.frame.origin;
    }

    @Override
    public double getZPosition() {
        return this.zPos;
    }

    @Override
    public void setZPosition(double zPosition) {
        this.zPos = zPosition;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public Font getFontRenderer() {
        return this.font;
    }
}

