/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.packet.PacketCustomChannel;
import java.util.Objects;
import mrtjp.projectred.core.ProjectRedCore;
import mrtjp.projectred.core.tile.IPacketReceiverBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.IEventBus;
import org.jetbrains.annotations.Nullable;

public class CoreNetwork {
    public static final ResourceLocation NET_CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"projectred_core", (String)"network");
    public static final int NET_TILE_PACKET_TO_CLIENT = 1;
    public static final int NET_TILE_PACKET_TO_SERVER = 3;
    private static final PacketCustomChannel channel = new PacketCustomChannel(NET_CHANNEL).versioned(ProjectRedCore.getContainer().getModInfo().getVersion().toString()).client(() -> ClientHandler::new).server(() -> ServerHandler::new);

    public static void init(IEventBus modBus) {
        channel.init(modBus);
    }

    public static PacketCustom createTileClientPacket(IPacketReceiverBlockEntity tile, byte key, @Nullable RegistryAccess registryAccess) {
        PacketCustom packet = new PacketCustom(NET_CHANNEL, 1, registryAccess);
        packet.writePos(tile.getBlockPosition());
        packet.writeByte((int)key);
        return packet;
    }

    public static PacketCustom createTileServerPacket(IPacketReceiverBlockEntity tile, byte key, @Nullable RegistryAccess registryAccess) {
        PacketCustom packet = new PacketCustom(NET_CHANNEL, 3, registryAccess);
        packet.writePos(tile.getBlockPosition());
        packet.writeByte((int)key);
        return packet;
    }

    private static class ServerHandler
    implements ICustomPacketHandler.IServerPacketHandler {
        private ServerHandler() {
        }

        public void handlePacket(PacketCustom packet, ServerPlayer sender) {
            switch (packet.getType()) {
                case 3: {
                    this.handleTilePacket(sender.level(), (MCDataInput)packet, sender);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid key received from client: " + packet.getType());
                }
            }
        }

        private void handleTilePacket(Level world, MCDataInput data, ServerPlayer sender) {
            BlockEntity tile = world.getBlockEntity(data.readPos());
            short key = data.readUByte();
            if (tile instanceof IPacketReceiverBlockEntity) {
                ((IPacketReceiverBlockEntity)tile).receiveUpdateFromClient(key, data, sender);
            }
        }
    }

    private static class ClientHandler
    implements ICustomPacketHandler.IClientPacketHandler {
        private ClientHandler() {
        }

        public void handlePacket(PacketCustom packet, Minecraft mc) {
            switch (packet.getType()) {
                case 1: {
                    this.handleTilePacket((Level)Objects.requireNonNull(mc.level), (MCDataInput)packet);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid key received from server: " + packet.getType());
                }
            }
        }

        private void handleTilePacket(Level world, MCDataInput data) {
            BlockEntity tile = world.getBlockEntity(data.readPos());
            short key = data.readUByte();
            if (tile instanceof IPacketReceiverBlockEntity) {
                ((IPacketReceiverBlockEntity)tile).receiveUpdateFromServer(key, data);
            }
        }
    }
}

