/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.part;

import javax.annotation.Nullable;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.RedstonePropagator;
import mrtjp.projectred.core.part.IConnectableFacePart;
import mrtjp.projectred.core.part.IPropagationHooks;
import mrtjp.projectred.core.part.IPropagationPart;

public interface IPropagationFacePart
extends IPropagationHooks,
IConnectableFacePart {
    default public void propagateOther(int mode) {
    }

    @Override
    default public void propagateForward(@Nullable IPropagationPart prev, int mode) {
        if (mode != 3) {
            RedstonePropagator.addPartChange(this);
        }
        for (int r = 0; r < 4; ++r) {
            if ((this.getPropagationMask() & 1 << r) == 0) continue;
            if (this.maskConnectsInside(r)) {
                this.propagateTo(this.getInternal(r), prev, mode);
                continue;
            }
            if (this.maskConnectsStraight(r)) {
                if (this.propagateTo(this.getStraight(r), prev, mode)) continue;
                RedstonePropagator.addNeighborChange(this.level(), this.pos(), this.posOfStraight(r));
                continue;
            }
            if (!this.maskConnectsCorner(r) || this.propagateTo(this.getCorner(r), prev, mode)) continue;
            RedstonePropagator.addNeighborChange(this.level(), this.posOfStraight(r), this.posOfCorner(r));
        }
        if (this.maskConnectsCenter()) {
            this.propagateTo(this.getCenter(), prev, mode);
        }
        this.propagateOther(mode);
    }

    @Override
    default public void propagateBackward(@Nullable IPropagationPart prev, int mode) {
        if (prev != null && this.shouldPropagate(prev, mode)) {
            RedstonePropagator.propagateTo(prev, this, mode);
        }
    }

    default public int getPropagationMask() {
        return 15;
    }

    default public boolean propagateTo(@Nullable IConnectable to, @Nullable IPropagationPart prev, int mode) {
        if (to != null) {
            IPropagationPart part;
            if (to == prev) {
                return false;
            }
            if (to instanceof IPropagationPart && this.shouldPropagate(part = (IPropagationPart)to, mode)) {
                RedstonePropagator.propagateTo(part, this, mode);
                return true;
            }
        }
        return false;
    }
}

